/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.extractMethod.ExtractMethodDecorator;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.refactoring.PyExtractMethodDialog;
import com.jetbrains.python.refactoring.PyRefactoringUiService;
import com.jetbrains.python.refactoring.extractmethod.PyExtractMethodSettings;
import com.jetbrains.python.refactoring.inline.PyInlineFunctionDialog;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import com.jetbrains.python.refactoring.introduce.PyIntroduceHandlerUi;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public final class PyRefactoringUiServiceImpl
extends PyRefactoringUiService {
    public void showIntroduceTargetChooser(final IntroduceOperation operation, Editor editor2, List<PyExpression> expressions, final Consumer<? super IntroduceOperation> callback) {
        IntroduceTargetChooser.showChooser((Editor)editor2, expressions, (Pass)new Pass<PyExpression>(this){

            public void pass(PyExpression pyExpression) {
                operation.setElement((PsiElement)pyExpression);
                callback.accept(operation);
            }
        }, pyExpression -> pyExpression.getText());
    }

    public void showOccurrencesChooser(final IntroduceOperation operation, Editor editor2, final Consumer<? super IntroduceOperation> callback) {
        OccurrencesChooser.simpleChooser((Editor)editor2).showChooser((Object)operation.getElement(), operation.getOccurrences(), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(this){

            public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                operation.setReplaceAll(replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
                callback.accept(operation);
            }
        });
    }

    public void performIntroduceWithDialog(IntroduceOperation operation, @NlsContexts.DialogTitle String dialogTitle, IntroduceValidator validator, String id, Consumer<? super IntroduceOperation> performRefactoringCallback) {
        PyIntroduceHandlerUi.performIntroduceWithDialog(operation, dialogTitle, validator, id, performRefactoringCallback);
    }

    public void performInplaceIntroduceVariable(IntroduceOperation operation, PsiElement statement) {
        PyIntroduceHandlerUi.performInplaceIntroduceVariable(operation, statement);
    }

    @Nullable
    public PyExtractMethodSettings showExtractMethodDialog(Project project, String defaultName, PyCodeFragment fragment, Object[] visibilityVariants, ExtractMethodValidator validator, ExtractMethodDecorator<Object> decorator, FileType type2, final String helpId) {
        PyExtractMethodDialog dialog = new PyExtractMethodDialog(this, project, defaultName, fragment, visibilityVariants, validator, decorator, type2){

            protected String getHelpId() {
                return helpId;
            }
        };
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        return dialog.getExtractMethodSettings();
    }

    public void showPyInlineFunctionDialog(Project project, Editor editor2, PyFunction function, @Nullable PsiReference reference) {
        new PyInlineFunctionDialog(project, editor2, function, reference).show();
    }
}

