/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.bytecode;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.bytecode.BytecodeLocal;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.Objects;

public final class LocalAccessor {
    private final int localOffset;
    private final int localIndex;
    private static final int CACHE_SIZE = 64;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final LocalAccessor[] CACHE = LocalAccessor.createCache();

    private LocalAccessor(int localOffset, int localIndex) {
        this.localOffset = localOffset;
        this.localIndex = localIndex;
    }

    public String toString() {
        return String.format("LocalAccessor[localOffset=%d, localIndex=%d]", this.localOffset, this.localIndex);
    }

    public Object getObject(BytecodeNode bytecodeNode, VirtualFrame frame) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.getLocalValueInternal(frame, this.localOffset, this.localIndex);
    }

    public boolean getBoolean(BytecodeNode bytecodeNode, VirtualFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.getLocalValueInternalBoolean(frame, this.localOffset, this.localIndex);
    }

    public byte getByte(BytecodeNode bytecodeNode, VirtualFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.getLocalValueInternalByte(frame, this.localOffset, this.localIndex);
    }

    public int getInt(BytecodeNode bytecodeNode, VirtualFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.getLocalValueInternalInt(frame, this.localOffset, this.localIndex);
    }

    public long getLong(BytecodeNode bytecodeNode, VirtualFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.getLocalValueInternalLong(frame, this.localOffset, this.localIndex);
    }

    public float getFloat(BytecodeNode bytecodeNode, VirtualFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.getLocalValueInternalFloat(frame, this.localOffset, this.localIndex);
    }

    public double getDouble(BytecodeNode bytecodeNode, VirtualFrame frame) throws UnexpectedResultException {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.getLocalValueInternalDouble(frame, this.localOffset, this.localIndex);
    }

    public void setObject(BytecodeNode bytecodeNode, VirtualFrame frame, Object value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        bytecodeNode.setLocalValueInternal(frame, this.localOffset, this.localIndex, value);
    }

    public void setBoolean(BytecodeNode bytecodeNode, VirtualFrame frame, boolean value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        bytecodeNode.setLocalValueInternalBoolean(frame, this.localOffset, this.localIndex, value);
    }

    public void setByte(BytecodeNode bytecodeNode, VirtualFrame frame, byte value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        bytecodeNode.setLocalValueInternalByte(frame, this.localOffset, this.localIndex, value);
    }

    public void setInt(BytecodeNode bytecodeNode, VirtualFrame frame, int value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        bytecodeNode.setLocalValueInternalInt(frame, this.localOffset, this.localIndex, value);
    }

    public void setLong(BytecodeNode bytecodeNode, VirtualFrame frame, long value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        bytecodeNode.setLocalValueInternalLong(frame, this.localOffset, this.localIndex, value);
    }

    public void setFloat(BytecodeNode bytecodeNode, VirtualFrame frame, float value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        bytecodeNode.setLocalValueInternalFloat(frame, this.localOffset, this.localIndex, value);
    }

    public void setDouble(BytecodeNode bytecodeNode, VirtualFrame frame, double value) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        bytecodeNode.setLocalValueInternalDouble(frame, this.localOffset, this.localIndex, value);
    }

    public void clear(BytecodeNode bytecodeNode, VirtualFrame frame) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        bytecodeNode.clearLocalValueInternal(frame, this.localOffset, this.localIndex);
    }

    public boolean isCleared(BytecodeNode bytecodeNode, VirtualFrame frame) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.isLocalClearedInternal(frame, this.localOffset, this.localIndex);
    }

    public Object getLocalName(BytecodeNode bytecodeNode) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.getLocalNameInternal(this.localOffset, this.localIndex);
    }

    public Object getLocalInfo(BytecodeNode bytecodeNode) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(bytecodeNode);
        return bytecodeNode.getLocalInfoInternal(this.localOffset, this.localIndex);
    }

    private static LocalAccessor[] createCache() {
        LocalAccessor[] setters = new LocalAccessor[64];
        for (int i = 0; i < setters.length; ++i) {
            setters[i] = new LocalAccessor(i, i);
        }
        return setters;
    }

    public static LocalAccessor constantOf(BytecodeLocal local) {
        int offset = local.getLocalOffset();
        int index = local.getLocalIndex();
        assert (offset <= index);
        if (index == offset && offset < 64) {
            return CACHE[offset];
        }
        return new LocalAccessor(offset, index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof LocalAccessor)) return false;
        LocalAccessor otherAccessor = (LocalAccessor)obj;
        if (this.localOffset != otherAccessor.localOffset) return false;
        if (this.localIndex != otherAccessor.localIndex) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.localOffset, this.localIndex);
    }
}

