/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.base.ParserMinimalBase;
import tools.jackson.core.exc.InputCoercionException;
import tools.jackson.core.exc.StreamConstraintsException;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.NumberInput;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.core.util.TextBuffer;

public abstract class ParserBase
extends ParserMinimalBase {
    protected int _inputPtr;
    protected int _inputEnd;
    protected long _currInputProcessed;
    protected int _currInputRow = 1;
    protected int _currInputRowStart;
    protected long _tokenInputTotal;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol;
    protected final TextBuffer _textBuffer;
    protected ByteArrayBuilder _byteArrayBuilder;
    protected byte[] _binaryValue;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected float _numberFloat;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected String _numberString;
    protected boolean _numberIsNaN;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;

    protected ParserBase(ObjectReadContext readCtxt, IOContext ctxt, int streamReadFeatures) {
        super(readCtxt, ctxt, streamReadFeatures);
        this._textBuffer = ctxt.constructReadConstrainedTextBuffer();
    }

    @Override
    public void assignCurrentValue(Object v) {
        TokenStreamContext ctxt = this.streamReadContext();
        if (ctxt != null) {
            ctxt.assignCurrentValue(v);
        }
    }

    @Override
    public Object currentValue() {
        TokenStreamContext ctxt = this.streamReadContext();
        return ctxt == null ? null : ctxt.currentValue();
    }

    @Override
    public void close() throws JacksonException {
        super.close();
        this._inputPtr = Math.max(this._inputPtr, this._inputEnd);
    }

    @Override
    public boolean hasStringCharacters() {
        return false;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant variant) throws JacksonException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (%s) not VALUE_EMBEDDED_OBJECT or VALUE_STRING, cannot access as binary", (Object)this._currToken);
            }
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this.getString(), builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    public long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    public int getTokenLineNr() {
        return this._tokenInputRow;
    }

    public int getTokenColumnNr() {
        int col = this._tokenInputCol;
        return col < 0 ? col : col + 1;
    }

    @Override
    protected void _releaseBuffers() {
        this._textBuffer.releaseBuffers();
    }

    @Override
    protected void _handleEOF() throws JacksonException {
        TokenStreamContext parsingContext = this.streamReadContext();
        if (parsingContext != null && !parsingContext.inRoot()) {
            String marker = parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", marker, parsingContext.startLocation(this._contentReference())), null);
        }
    }

    protected final int _eofAsNextChar() throws StreamReadException {
        this._handleEOF();
        return -1;
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected final JsonToken reset(boolean negative, int intLen, int fractLen, int expLen) throws JacksonException {
        if (fractLen < 1 && expLen < 1) {
            return this.resetInt(negative, intLen);
        }
        return this.resetFloat(negative, intLen, fractLen, expLen);
    }

    protected final JsonToken resetInt(boolean negative, int intLen) throws JacksonException {
        this._streamReadConstraints.validateIntegerLength(intLen);
        this._numberNegative = negative;
        this._numberIsNaN = false;
        this._intLength = intLen;
        this._fractLength = 0;
        this._expLength = 0;
        this._numTypesValid = 0;
        this._numberString = null;
        return JsonToken.VALUE_NUMBER_INT;
    }

    protected final JsonToken resetFloat(boolean negative, int intLen, int fractLen, int expLen) throws JacksonException {
        this._streamReadConstraints.validateFPLength(intLen + fractLen + expLen);
        this._numberNegative = negative;
        this._numberIsNaN = false;
        this._intLength = intLen;
        this._fractLength = fractLen;
        this._expLength = expLen;
        this._numTypesValid = 0;
        this._numberString = null;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    protected final JsonToken resetAsNaN(String valueStr, double value) {
        this._textBuffer.resetWithString(valueStr);
        this._numberDouble = value;
        this._numTypesValid = 8;
        this._numberIsNaN = true;
        this._numberString = null;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public boolean isNaN() {
        return this._currToken == JsonToken.VALUE_NUMBER_FLOAT && this._numberIsNaN;
    }

    @Override
    public Number getNumberValue() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._getBigDecimal();
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return Float.valueOf(this._getNumberFloat());
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._getNumberDouble();
    }

    @Override
    public Number getNumberValueExact() {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(0);
            }
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if (this._numTypesValid == 0) {
            this._parseNumericValue(16);
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._getBigDecimal();
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return Float.valueOf(this._getNumberFloat());
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._getNumberDouble();
    }

    @Override
    public Object getNumberValueDeferred() {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(0);
            }
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                if (this._numberBigInt != null) {
                    return this._numberBigInt;
                }
                if (this._numberString != null) {
                    return this._numberString;
                }
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 0x10) != 0) {
                return this._getBigDecimal();
            }
            if ((this._numTypesValid & 8) != 0) {
                return this._getNumberDouble();
            }
            if ((this._numTypesValid & 0x20) != 0) {
                return Float.valueOf(this._getNumberFloat());
            }
            return this._textBuffer.contentsAsString();
        }
        return this.getNumberValue();
    }

    @Override
    public JsonParser.NumberType getNumberType() {
        if (this._numTypesValid == 0) {
            if (this._currToken != JsonToken.VALUE_NUMBER_INT && this._currToken != JsonToken.VALUE_NUMBER_FLOAT) {
                return null;
            }
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return JsonParser.NumberType.FLOAT;
        }
        return JsonParser.NumberType.DOUBLE;
    }

    @Override
    public int getIntValue() throws JacksonException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                return this._parseIntValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() throws JacksonException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() throws JacksonException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
                return this._numberBigInt;
            }
        }
        return this._getBigInteger();
    }

    @Override
    public float getFloatValue() throws JacksonException {
        if ((this._numTypesValid & 0x20) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(32);
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
                return this._numberFloat;
            }
        }
        return this._getNumberFloat();
    }

    @Override
    public double getDoubleValue() throws JacksonException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
                return this._numberDouble;
            }
        }
        return this._getNumberDouble();
    }

    @Override
    public BigDecimal getDecimalValue() throws JacksonException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
                return this._numberBigDecimal;
            }
        }
        return this._getBigDecimal();
    }

    protected abstract void _parseNumericValue(int var1) throws JacksonException, InputCoercionException;

    protected abstract int _parseIntValue() throws JacksonException;

    protected void convertNumberToInt() throws InputCoercionException {
        if ((this._numTypesValid & 2) != 0) {
            int result = (int)this._numberLong;
            if ((long)result != this._numberLong) {
                this._reportOverflowInt(this.getString(), this.currentToken());
            }
            this._numberInt = result;
        } else if ((this._numTypesValid & 4) != 0) {
            BigInteger bigInteger = this._getBigInteger();
            if (BI_MIN_INT.compareTo(bigInteger) > 0 || BI_MAX_INT.compareTo(bigInteger) < 0) {
                this._reportOverflowInt();
            }
            this._numberInt = bigInteger.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            double d = this._getNumberDouble();
            if (d < -2.147483648E9 || d > 2.147483647E9) {
                this._reportOverflowInt();
            }
            this._numberInt = (int)d;
        } else if ((this._numTypesValid & 0x10) != 0) {
            BigDecimal bigDecimal = this._getBigDecimal();
            if (BD_MIN_INT.compareTo(bigDecimal) > 0 || BD_MAX_INT.compareTo(bigDecimal) < 0) {
                this._reportOverflowInt();
            }
            this._numberInt = bigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() throws InputCoercionException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            BigInteger bigInteger = this._getBigInteger();
            if (BI_MIN_LONG.compareTo(bigInteger) > 0 || BI_MAX_LONG.compareTo(bigInteger) < 0) {
                this._reportOverflowLong();
            }
            this._numberLong = bigInteger.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            double d = this._getNumberDouble();
            if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                this._reportOverflowLong();
            }
            this._numberLong = (long)d;
        } else if ((this._numTypesValid & 0x10) != 0) {
            BigDecimal bigDecimal = this._getBigDecimal();
            if (BD_MIN_LONG.compareTo(bigDecimal) > 0 || BD_MAX_LONG.compareTo(bigDecimal) < 0) {
                this._reportOverflowLong();
            }
            this._numberLong = bigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._convertBigDecimalToBigInteger(this._getBigDecimal());
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = this._numberString != null ? this._convertBigDecimalToBigInteger(this._getBigDecimal()) : this._convertBigDecimalToBigInteger(BigDecimal.valueOf(this._getNumberDouble()));
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberString != null ? this._getNumberDouble() : this._getBigDecimal().doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberString != null ? this._getNumberDouble() : this._getBigInteger().doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberDouble = this._numberString != null ? this._getNumberDouble() : (double)this._getNumberFloat();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToFloat() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberFloat = this._numberString != null ? this._getNumberFloat() : this._getBigDecimal().floatValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberFloat = this._numberString != null ? this._getNumberFloat() : this._getBigInteger().floatValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberFloat = this._numberString != null ? this._getNumberFloat() : (float)this._getNumberDouble();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    protected void convertNumberToBigDecimal() {
        if ((this._numTypesValid & 8) != 0) {
            String numStr = this._numberString == null ? this.getString() : this._numberString;
            this._numberBigDecimal = NumberInput.parseBigDecimal(numStr, this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._getBigInteger());
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected BigInteger _convertBigDecimalToBigInteger(BigDecimal bigDec) {
        this._streamReadConstraints.validateBigIntegerScale(bigDec.scale());
        return bigDec.toBigInteger();
    }

    protected BigInteger _getBigInteger() {
        if (this._numberBigInt != null) {
            return this._numberBigInt;
        }
        if (this._numberString == null) {
            throw new IllegalStateException("cannot get BigInteger from current parser state");
        }
        try {
            this._numberBigInt = NumberInput.parseBigInteger(this._numberString, this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
        }
        catch (NumberFormatException nex) {
            throw this._constructReadException("Malformed numeric value (" + this._longNumberDesc(this._numberString) + ")", nex);
        }
        this._numberString = null;
        return this._numberBigInt;
    }

    protected BigDecimal _getBigDecimal() {
        if (this._numberBigDecimal != null) {
            return this._numberBigDecimal;
        }
        if (this._numberString == null) {
            throw new IllegalStateException("cannot get BigDecimal from current parser state");
        }
        try {
            this._numberBigDecimal = NumberInput.parseBigDecimal(this._numberString, this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
        }
        catch (NumberFormatException nex) {
            throw this._constructReadException("Malformed numeric value (" + this._longNumberDesc(this._numberString) + ")", nex);
        }
        this._numberString = null;
        return this._numberBigDecimal;
    }

    protected double _getNumberDouble() {
        if (this._numberString != null) {
            try {
                this._numberDouble = NumberInput.parseDouble(this._numberString, this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            }
            catch (NumberFormatException nex) {
                throw this._constructReadException("Malformed numeric value (" + this._longNumberDesc(this._numberString) + ")", nex);
            }
            this._numberString = null;
        }
        return this._numberDouble;
    }

    protected float _getNumberFloat() {
        if (this._numberString != null) {
            try {
                this._numberFloat = NumberInput.parseFloat(this._numberString, this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            }
            catch (NumberFormatException nex) {
                throw this._constructReadException("Malformed numeric value (" + this._longNumberDesc(this._numberString) + ")", nex);
            }
            this._numberString = null;
        }
        return this._numberFloat;
    }

    protected char _decodeEscaped() throws JacksonException {
        throw new UnsupportedOperationException();
    }

    protected final int _decodeBase64Escape(Base64Variant b64variant, int ch, int index) throws JacksonException {
        char unescaped;
        if (ch != 92) {
            this._reportInvalidBase64Char(b64variant, ch, index);
        }
        if ((unescaped = this._decodeEscaped()) <= ' ' && index == 0) {
            return -1;
        }
        int bits = b64variant.decodeBase64Char((int)unescaped);
        if (bits < 0 && bits != -2) {
            this._reportInvalidBase64Char(b64variant, unescaped, index);
        }
        return bits;
    }

    protected final int _decodeBase64Escape(Base64Variant b64variant, char ch, int index) throws JacksonException {
        if (ch != '\\') {
            this._reportInvalidBase64Char(b64variant, ch, index);
            return -1;
        }
        char unescaped = this._decodeEscaped();
        if (unescaped <= ' ' && index == 0) {
            return -1;
        }
        int bits = b64variant.decodeBase64Char(unescaped);
        if (bits < 0 && (bits != -2 || index < 2)) {
            this._reportInvalidBase64Char(b64variant, unescaped, index);
        }
        return bits;
    }

    protected <T> T _reportInvalidBase64Char(Base64Variant b64variant, int ch, int bindex) throws StreamReadException {
        return this._reportInvalidBase64Char(b64variant, ch, bindex, null);
    }

    protected <T> T _reportInvalidBase64Char(Base64Variant b64variant, int ch, int bindex, String msg) throws StreamReadException {
        Object base = ch <= 32 ? String.format("Illegal white space character (code 0x%s) as character #%d of 4-char base64 unit: can only used between units", Integer.toHexString(ch), bindex + 1) : (b64variant.usesPaddingChar(ch) ? "Unexpected padding character ('" + b64variant.getPaddingChar() + "') as character #" + (bindex + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(ch) || Character.isISOControl(ch) ? "Illegal character (code 0x" + Integer.toHexString(ch) + ") in base64 content" : "Illegal character '" + (char)ch + "' (code 0x" + Integer.toHexString(ch) + ") in base64 content"));
        if (msg != null) {
            base = (String)base + ": " + msg;
        }
        return this._reportError((String)base);
    }

    protected <T> T _handleBase64MissingPadding(Base64Variant b64variant) throws StreamReadException {
        return this._reportError(b64variant.missingPaddingMessage());
    }

    protected ContentReference _contentReference() {
        if (this.isEnabled(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION)) {
            return this._ioContext.contentReference();
        }
        return this._contentReferenceRedacted();
    }

    protected ContentReference _contentReferenceRedacted() {
        return ContentReference.redacted();
    }

    protected static int[] growArrayBy(int[] arr, int more) throws IllegalArgumentException {
        if (arr == null) {
            return new int[more];
        }
        int len = arr.length + more;
        if (len < 0) {
            throw new IllegalArgumentException("Unable to grow array to longer than `Integer.MAX_VALUE`");
        }
        return Arrays.copyOf(arr, len);
    }

    protected int[] _growNameDecodeBuffer(int[] arr, int more) throws StreamConstraintsException {
        this._streamReadConstraints.validateNameLength(arr.length << 2);
        return ParserBase.growArrayBy(arr, more);
    }
}

