/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.types;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.types.GenericAliasBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.types.GenericAliasBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.types.GenericTypeNodes;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.lib.PyObjectDir;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGenericAlias})
public final class GenericAliasBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = GenericAliasBuiltinsSlotsGen.SLOTS;
    private static final TruffleString[] ATTR_EXCEPTIONS = new TruffleString[]{SpecialAttributeNames.T___CLASS__, SpecialAttributeNames.T___ORIGIN__, SpecialAttributeNames.T___ARGS__, SpecialAttributeNames.T___UNPACKED__, SpecialAttributeNames.T___PARAMETERS__, GenericTypeNodes.T___TYPING_UNPACKED_TUPLE_ARGS__, SpecialMethodNames.T___MRO_ENTRIES__, SpecialMethodNames.T___REDUCE_EX__, SpecialMethodNames.T___REDUCE__, SpecialMethodNames.T___COPY__, SpecialMethodNames.T___DEEPCOPY__};

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GenericAliasBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static Object iter(PGenericAlias self, @Bind PythonLanguage language) {
            return PFactory.createGenericAliasIterator(language, self);
        }
    }

    @Builtin(name="__typing_unpacked_tuple_args__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class TypingUnpackedTupleArgsNode
    extends PythonUnaryBuiltinNode {
        TypingUnpackedTupleArgsNode() {
        }

        @Specialization
        static Object get(PGenericAlias self, @Bind Node inliningTarget, @Cached TypeNodes.IsSameTypeNode isSameTypeNode) {
            if (self.isStarred() && isSameTypeNode.execute(inliningTarget, self.getOrigin(), (Object)PythonBuiltinClassType.PTuple)) {
                return self.getArgs();
            }
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        GetItemNode() {
        }

        @Specialization
        static Object getitem(PGenericAlias self, Object item, @Bind Node inliningTarget, @Bind PythonLanguage language) {
            if (self.getParameters() == null) {
                self.setParameters(PFactory.createTuple(language, GenericTypeNodes.makeParameters(self.getArgs())));
            }
            Object[] newargs = GenericTypeNodes.subsParameters(inliningTarget, self, self.getArgs(), self.getParameters(), item);
            PTuple newargsTuple = PFactory.createTuple(language, newargs);
            return PFactory.createGenericAlias(language, self.getOrigin(), newargsTuple, self.isStarred());
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DirNode
    extends PythonUnaryBuiltinNode {
        DirNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object dir(PGenericAlias self, @Bind Node inliningTarget, @Cached PyObjectDir dir, @Cached PySequenceContainsNode containsNode, @Cached ListNodes.AppendNode appendNode) {
            PList list = dir.execute(null, inliningTarget, self.getOrigin());
            for (int i = 0; i < ATTR_EXCEPTIONS.length; ++i) {
                if (containsNode.execute(null, inliningTarget, list, ATTR_EXCEPTIONS[i])) continue;
                appendNode.execute(list, ATTR_EXCEPTIONS[i]);
            }
            return list;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        ReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PGenericAlias self, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectGetIter getIter, @Cached PyObjectGetAttr getAttr, @Bind PythonLanguage language) {
            if (self.isStarred()) {
                PGenericAlias copy = PFactory.createGenericAlias(language, self.getOrigin(), self.getArgs());
                PythonModule builtins = PythonContext.get(inliningTarget).getBuiltins();
                Object next = getAttr.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_NEXT);
                PTuple args = PFactory.createTuple(language, new Object[]{getIter.execute((Frame)frame, inliningTarget, copy)});
                return PFactory.createTuple(language, new Object[]{next, args});
            }
            PTuple args = PFactory.createTuple(language, new Object[]{self.getOrigin(), self.getArgs()});
            return PFactory.createTuple(language, new Object[]{getClassNode.execute(inliningTarget, self), args});
        }
    }

    @Builtin(name="__subclasscheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SubclassCheckNode
    extends PythonBinaryBuiltinNode {
        SubclassCheckNode() {
        }

        @Specialization
        static Object check(PGenericAlias self, Object other, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ISSUBCLASS_ARG_2_CANNOT_BE_A_PARAMETERIZED_GENERIC);
        }
    }

    @Builtin(name="__instancecheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InstanceCheckNode
    extends PythonBinaryBuiltinNode {
        InstanceCheckNode() {
        }

        @Specialization
        static Object check(PGenericAlias self, Object other, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ISINSTANCE_ARG_2_CANNOT_BE_A_PARAMETERIZED_GENERIC);
        }
    }

    @Builtin(name="__mro_entries__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MroEntriesNode
    extends PythonBinaryBuiltinNode {
        MroEntriesNode() {
        }

        @Specialization
        static Object mro(PGenericAlias self, Object bases, @Bind PythonLanguage language) {
            return PFactory.createTuple(language, new Object[]{self.getOrigin()});
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    static abstract class EqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        EqNode() {
        }

        @Specialization(guards={"op.isEqOrNe()"})
        static boolean eq(VirtualFrame frame, PGenericAlias self, PGenericAlias other, RichCmpOp op, @Bind Node inliningTarget, @Cached PyObjectRichCompareBool eqOrigin, @Cached PyObjectRichCompareBool eqArgs) {
            if (self.isStarred() != other.isStarred()) {
                return op.isNe();
            }
            if (!eqOrigin.executeEq((Frame)frame, inliningTarget, self.getOrigin(), other.getOrigin())) {
                return op.isNe();
            }
            return eqArgs.executeEq((Frame)frame, inliningTarget, self.getArgs(), other.getArgs()) == op.isEq();
        }

        @Fallback
        static Object eq(Object self, Object other, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetAttributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        GetAttributeNode() {
        }

        @Specialization
        @ExplodeLoop
        static Object getattribute(VirtualFrame frame, PGenericAlias self, Object nameObj, @Bind Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached TruffleString.EqualNode equalNode, @Cached PyObjectGetAttr getAttr, @Cached ObjectBuiltins.GetAttributeNode genericGetAttribute) {
            TruffleString name;
            try {
                name = cast.execute(inliningTarget, nameObj);
            }
            catch (CannotCastException e) {
                return genericGetAttribute.execute(frame, self, nameObj);
            }
            for (int i = 0; i < ATTR_EXCEPTIONS.length; ++i) {
                if (!equalNode.execute((AbstractTruffleString)name, (AbstractTruffleString)ATTR_EXCEPTIONS[i], PythonUtils.TS_ENCODING)) continue;
                return genericGetAttribute.execute(frame, self, nameObj);
            }
            return getAttr.execute((Frame)frame, inliningTarget, self.getOrigin(), name);
        }
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class CallMethodNode
    extends PythonVarargsBuiltinNode {
        CallMethodNode() {
        }

        @Specialization
        static Object call(VirtualFrame frame, PGenericAlias self, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached CallNode callNode, @Cached PyObjectSetAttr setAttr, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile typeErrorProfile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attributeErrorProfile) {
            Object result;
            block2: {
                result = callNode.execute((Frame)frame, self.getOrigin(), args, kwargs);
                try {
                    setAttr.execute((Frame)frame, inliningTarget, result, SpecialAttributeNames.T___ORIG_CLASS__, self);
                }
                catch (PException e) {
                    if (typeErrorProfile.profileException(inliningTarget, e, PythonBuiltinClassType.TypeError) || attributeErrorProfile.profileException(inliningTarget, e, PythonBuiltinClassType.AttributeError)) break block2;
                    throw e;
                }
            }
            return result;
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        HashNode() {
        }

        @Specialization
        static long hash(VirtualFrame frame, PGenericAlias self, @Bind Node inliningTarget, @Cached PyObjectHashNode hashOrigin, @Cached PyObjectHashNode hashArgs) {
            long h0 = hashOrigin.execute((Frame)frame, inliningTarget, self.getOrigin());
            long h1 = hashArgs.execute((Frame)frame, inliningTarget, self.getArgs());
            return h0 ^ h1;
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString SEPARATOR = PythonUtils.tsLiteral(", ");

        ReprNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object repr(PGenericAlias self) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            if (self.isStarred()) {
                sb.appendCodePointUncached(42);
            }
            ReprNode.reprItem(sb, self.getOrigin());
            sb.appendCodePointUncached(91);
            SequenceStorage argsStorage = self.getArgs().getSequenceStorage();
            for (int i = 0; i < argsStorage.length(); ++i) {
                Object p;
                if (i > 0) {
                    sb.appendStringUncached(SEPARATOR);
                }
                if ((p = SequenceStorageNodes.GetItemScalarNode.executeUncached(argsStorage, i)) instanceof PList) {
                    PList list = (PList)p;
                    ReprNode.reprItemsList(sb, list);
                    continue;
                }
                ReprNode.reprItem(sb, p);
            }
            if (argsStorage.length() == 0) {
                sb.appendCodePointUncached(40);
                sb.appendCodePointUncached(41);
            }
            sb.appendCodePointUncached(93);
            return sb.toStringUncached();
        }

        private static void reprItem(TruffleStringBuilder sb, Object obj) {
            if (obj == PEllipsis.INSTANCE) {
                sb.appendStringUncached(StringLiterals.T_ELLIPSIS);
                return;
            }
            GenericTypeNodes.reprItem(sb, obj);
        }

        private static void reprItemsList(TruffleStringBuilder sb, PList list) {
            sb.appendCodePointUncached(91);
            SequenceStorage storage = list.getSequenceStorage();
            for (int i = 0; i < storage.length(); ++i) {
                if (i > 0) {
                    sb.appendStringUncached(SEPARATOR);
                }
                Object p = SequenceStorageNodes.GetItemScalarNode.executeUncached(storage, i);
                ReprNode.reprItem(sb, p);
            }
            sb.appendCodePointUncached(93);
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        static Object union(Object self, Object other, @Cached GenericTypeNodes.UnionTypeOrNode orNode) {
            return orNode.execute(self, other);
        }
    }

    @Builtin(name="__unpacked__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class UnpackedNode
    extends PythonUnaryBuiltinNode {
        UnpackedNode() {
        }

        @Specialization
        static Object unpacked(PGenericAlias self) {
            return self.isStarred();
        }
    }

    @Builtin(name="__parameters__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ParametersNode
    extends PythonUnaryBuiltinNode {
        ParametersNode() {
        }

        @Specialization
        static Object parameters(PGenericAlias self, @Bind Node inliningTarget, @Cached InlinedBranchProfile createProfile) {
            if (self.getParameters() == null) {
                createProfile.enter(inliningTarget);
                self.setParameters(PFactory.createTuple(PythonLanguage.get(inliningTarget), GenericTypeNodes.makeParameters(self.getArgs())));
            }
            return self.getParameters();
        }
    }

    @Builtin(name="__args__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ArgsNode
    extends PythonUnaryBuiltinNode {
        ArgsNode() {
        }

        @Specialization
        static Object args(PGenericAlias self) {
            return self.getArgs();
        }
    }

    @Builtin(name="__origin__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class OriginNode
    extends PythonUnaryBuiltinNode {
        OriginNode() {
        }

        @Specialization
        static Object origin(PGenericAlias self) {
            return self.getOrigin();
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="GenericAlias", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class GenericAliasNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static PGenericAlias doit(Object cls, Object origin, Object arguments, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createGenericAlias(language, cls, getInstanceShape.execute(cls), origin, arguments, false);
        }
    }
}

