/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.HiddenAttrFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;

public final class HiddenAttr {
    public static final HiddenAttr OBJECT_ID = new HiddenAttr("_id");
    public static final HiddenAttr CLASS = new HiddenAttr("ob_type");
    public static final HiddenAttr DICT = new HiddenAttr("ob_dict");
    public static final HiddenAttr DICTOFFSET = new HiddenAttr("__dictoffset__");
    public static final HiddenAttr WEAKLISTOFFSET = new HiddenAttr("__weaklistoffset__");
    public static final HiddenAttr ITEMSIZE = new HiddenAttr("__itemsize__");
    public static final HiddenAttr BASICSIZE = new HiddenAttr("__basicsize__");
    public static final HiddenAttr ALLOC = new HiddenAttr("__alloc__");
    public static final HiddenAttr DEALLOC = new HiddenAttr("__dealloc__");
    public static final HiddenAttr DEL = new HiddenAttr("__del__");
    public static final HiddenAttr FREE = new HiddenAttr("__free__");
    public static final HiddenAttr TRAVERSE = new HiddenAttr("tp_traverse");
    public static final HiddenAttr IS_GC = new HiddenAttr("tp_is_gc");
    public static final HiddenAttr CLEAR = new HiddenAttr("__clear__");
    public static final HiddenAttr AS_BUFFER = new HiddenAttr("__tp_as_buffer__");
    public static final HiddenAttr FLAGS = new HiddenAttr("__flags__");
    public static final HiddenAttr VECTORCALL_OFFSET = new HiddenAttr("__vectorcalloffset__");
    public static final HiddenAttr GETBUFFER = new HiddenAttr("__getbuffer__");
    public static final HiddenAttr RELEASEBUFFER = new HiddenAttr("__releasebuffer__");
    public static final HiddenAttr WEAKLIST = new HiddenAttr("__weaklist__");
    public static final HiddenAttr WEAK_REF_QUEUE = new HiddenAttr("weakRefQueue");
    public static final HiddenAttr ENCODER_OBJECT = new HiddenAttr("encoder_object");
    public static final HiddenAttr DECODER_OBJECT = new HiddenAttr("decoder_object");
    public static final HiddenAttr PICKLE_STATE = new HiddenAttr("state");
    public static final HiddenAttr NEXT_ELEMENT = new HiddenAttr("next_element");
    public static final HiddenAttr INTERNED = new HiddenAttr("_interned");
    public static final HiddenAttr HOST_INTEROP_BEHAVIOR = new HiddenAttr("__graalpython_interop_behavior__");
    public static final HiddenAttr TREGEX_CACHE = new HiddenAttr("tregex_cache");
    public static final HiddenAttr METHOD_DEF_PTR = new HiddenAttr("method_def_ptr");
    public static final HiddenAttr PROMOTED_START = new HiddenAttr("promoted_start");
    public static final HiddenAttr PROMOTED_STEP = new HiddenAttr("promoted_step");
    public static final HiddenAttr PROMOTED_STOP = new HiddenAttr("promoted_stop");
    public static final HiddenAttr NATIVE_STORAGE = new HiddenAttr("native_storage");
    public static final HiddenAttr NATIVE_SLOTS = new HiddenAttr("__native_slots__");
    public static final HiddenAttr INSTANCESHAPE = new HiddenAttr("instanceshape");
    public static final HiddenAttr STRUCTSEQ_FIELD_NAMES = new HiddenAttr("struct_seq_field_names");
    private final HiddenKey key;

    private HiddenAttr(String keyName) {
        this.key = new HiddenKey(keyName);
    }

    public static HiddenKey getClassHiddenKey() {
        return HiddenAttr.CLASS.key;
    }

    public String getName() {
        return this.key.getName();
    }

    public String toString() {
        return this.getName();
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    @ImportStatic(value={HiddenAttr.class})
    public static abstract class WriteNode
    extends Node {
        public abstract void execute(Node var1, PythonAbstractObject var2, HiddenAttr var3, Object var4);

        public final void executeCached(PythonAbstractObject self, HiddenAttr attr, Object value) {
            this.execute(this, self, attr, value);
        }

        public static void executeUncached(PythonAbstractObject self, HiddenAttr attr, Object value) {
            HiddenAttrFactory.WriteNodeGen.getUncached().execute(null, self, attr, value);
        }

        @Specialization(guards={"attr == DICT"})
        static void doPythonObjectDict(PythonObject self, HiddenAttr attr, Object value, @Cached.Shared @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            dylib.setShapeFlags((DynamicObject)self, dylib.getShapeFlags((DynamicObject)self) | 8);
            dylib.put((DynamicObject)self, (Object)HiddenAttr.DICT.key, value);
        }

        @Specialization(guards={"attr == CLASS"})
        static void doPythonObjectClass(PythonObject self, HiddenAttr attr, Object value, @Cached.Shared @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            dylib.setShapeFlags((DynamicObject)self, dylib.getShapeFlags((DynamicObject)self) | 1);
            dylib.put((DynamicObject)self, (Object)HiddenAttr.CLASS.key, value);
        }

        @Specialization(guards={"!isSpecialCaseAttr(attr) || !isPythonObject(self)"})
        static void doGeneric(PythonAbstractObject self, HiddenAttr attr, Object value, @Cached.Shared @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            dylib.put((DynamicObject)self, (Object)attr.key, value);
        }

        protected static boolean isPythonObject(Object object) {
            return object instanceof PythonObject;
        }

        protected static boolean isSpecialCaseAttr(HiddenAttr attr) {
            return attr == DICT || attr == CLASS;
        }

        @NeverDefault
        public static WriteNode create() {
            return HiddenAttrFactory.WriteNodeGen.create();
        }

        @NeverDefault
        public static WriteNode getUncached() {
            return HiddenAttrFactory.WriteNodeGen.getUncached();
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    public static abstract class ReadNode
    extends Node {
        public abstract Object execute(Node var1, PythonAbstractObject var2, HiddenAttr var3, Object var4);

        public final Object executeCached(PythonAbstractObject self, HiddenAttr attr, Object defaultValue) {
            return this.execute(this, self, attr, defaultValue);
        }

        public static Object executeUncached(PythonAbstractObject self, HiddenAttr attr, Object defaultValue) {
            return HiddenAttrFactory.ReadNodeGen.getUncached().execute(null, self, attr, defaultValue);
        }

        @Specialization
        static Object doGeneric(PythonAbstractObject self, HiddenAttr attr, Object defaultValue, @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            return dylib.getOrDefault((DynamicObject)self, (Object)attr.key, defaultValue);
        }

        @NeverDefault
        public static ReadNode create() {
            return HiddenAttrFactory.ReadNodeGen.create();
        }

        @NeverDefault
        public static ReadNode getUncached() {
            return HiddenAttrFactory.ReadNodeGen.getUncached();
        }
    }
}

