/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.argument;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.argument.ReadVarArgsNodeGen;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;

public abstract class ReadVarArgsNode
extends ReadArgumentNode {
    private final boolean isBuiltin;

    ReadVarArgsNode(boolean isBuiltin) {
        this.isBuiltin = isBuiltin;
    }

    public static ReadVarArgsNode create() {
        return ReadVarArgsNode.create(false);
    }

    public static ReadVarArgsNode create(boolean isBuiltin) {
        return ReadVarArgsNodeGen.create(isBuiltin);
    }

    public abstract Object[] executeObjectArray(VirtualFrame var1);

    @Specialization
    Object extractVariableVarargs(VirtualFrame frame) {
        return this.output(PArguments.getVariableArguments((Frame)frame));
    }

    private Object output(Object[] varArgs) {
        if (this.isBuiltin()) {
            return varArgs;
        }
        return PFactory.createTuple(PythonLanguage.get(this), varArgs);
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }
}

