/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin.httpserver;

import com.amazon.redshift.plugin.httpserver.InvalidHttpRequestHandler;
import com.amazon.redshift.plugin.httpserver.ValidHttpRequestHandler;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.RequestLine;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class RequestHandler
implements HttpRequestHandler {
    public static final String REDSHIFT_PATH = "/redshift/";
    public static final String REDSHIFT_IDC_PATH = "/?code=";
    private static final String SUPPORTED_METHOD_POST = "POST";
    private static final String SUPPORTED_METHOD_GET = "GET";
    private final Function<List<NameValuePair>, Object> m_requestProcessLogic;
    private final HttpRequestHandler m_invalidRequestHandler;
    private final HttpRequestHandler m_validRequestHandler;
    private Object m_result;
    private boolean is_valid_result = false;

    public RequestHandler(Function<List<NameValuePair>, Object> requestProcessLogic) {
        this.m_requestProcessLogic = requestProcessLogic;
        this.m_invalidRequestHandler = new InvalidHttpRequestHandler();
        this.m_validRequestHandler = new ValidHttpRequestHandler();
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (this.isRequestValid(request)) {
            this.m_result = this.m_requestProcessLogic.apply(URLEncodedUtils.parse((HttpEntity)((BasicHttpEntityEnclosingRequest)request).getEntity()));
            this.is_valid_result = true;
            this.m_validRequestHandler.handle(request, response, context);
        } else if (this.isIdcRequestValid(request)) {
            String query = RequestHandler.extractQuery(request.toString());
            this.m_result = this.m_requestProcessLogic.apply(URLEncodedUtils.parse((String)query, (Charset)StandardCharsets.UTF_8));
            this.is_valid_result = true;
            this.m_validRequestHandler.handle(request, response, context);
        } else {
            this.is_valid_result = false;
            this.m_invalidRequestHandler.handle(request, response, context);
        }
    }

    private boolean isRequestValid(HttpRequest request) {
        RequestLine requestLine = request.getRequestLine();
        if (!SUPPORTED_METHOD_POST.equalsIgnoreCase(requestLine.getMethod())) {
            return false;
        }
        return requestLine.getUri().startsWith(REDSHIFT_PATH);
    }

    private boolean isIdcRequestValid(HttpRequest request) {
        RequestLine requestLine = request.getRequestLine();
        if (!SUPPORTED_METHOD_GET.equalsIgnoreCase(requestLine.getMethod())) {
            return false;
        }
        return requestLine.getUri().startsWith(REDSHIFT_IDC_PATH);
    }

    private static String extractQuery(String target) {
        int spaceIndex;
        int queryIndex = target.indexOf(63);
        if (queryIndex != -1) {
            target = target.substring(queryIndex + 1);
        }
        if ((spaceIndex = target.indexOf(32)) != -1) {
            return target.substring(0, spaceIndex + 1);
        }
        return "";
    }

    public Object getResult() {
        return this.m_result;
    }

    public boolean hasResult() {
        return this.m_result != null;
    }

    public boolean hasValidResult() {
        return this.is_valid_result;
    }

    public void resetValidResult() {
        this.is_valid_result = false;
    }
}

