/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarIdentifierWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalParserRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.ParseISODateTimeResult;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToRelativeTemporalObjectNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getRelativeToNode;
    @Node.Child
    private PropertyGetNode getOffsetNode;
    @Node.Child
    private PropertyGetNode getTimeZoneNode;

    protected ToRelativeTemporalObjectNode() {
        JSContext ctx = JavaScriptLanguage.get(null).getJSContext();
        this.getRelativeToNode = PropertyGetNode.create(TemporalConstants.RELATIVE_TO, ctx);
        this.getOffsetNode = PropertyGetNode.create(TemporalConstants.OFFSET, ctx);
        this.getTimeZoneNode = PropertyGetNode.create(TemporalConstants.TIME_ZONE, ctx);
    }

    public abstract Result execute(JSDynamicObject var1);

    @Specialization
    protected Result toRelativeTemporalObject(JSDynamicObject options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile valueIsObject, @Cached InlinedConditionProfile valueIsUndefined, @Cached InlinedBranchProfile valueIsPlainDate, @Cached InlinedBranchProfile valueIsZonedDateTime, @Cached InlinedConditionProfile valueIsPlainDateTime, @Cached InlinedConditionProfile timeZoneAvailable, @Cached IsObjectNode isObjectNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier, @Cached GetTemporalCalendarIdentifierWithISODefaultNode getTemporalCalendarWithISODefaultNode, @Cached TruffleString.ToJavaStringNode toJavaString, @Cached TruffleString.FromJavaStringNode fromJavaString) {
        Object offsetString;
        JSTemporalDateTimeRecord result;
        TruffleString calendar;
        Object value = this.getRelativeToNode.getValue((Object)options);
        if (valueIsUndefined.profile((Node)this, value == Undefined.instance)) {
            return ToRelativeTemporalObjectNode.none();
        }
        TruffleString timeZone = null;
        TemporalUtil.OffsetBehaviour offsetBehaviour = TemporalUtil.OffsetBehaviour.OPTION;
        TemporalUtil.MatchBehaviour matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (value instanceof JSTemporalPlainDateObject) {
            JSTemporalPlainDateObject plainDate = (JSTemporalPlainDateObject)((Object)value);
            valueIsPlainDate.enter((Node)this);
            return ToRelativeTemporalObjectNode.plainDate(plainDate);
        }
        if (value instanceof JSTemporalZonedDateTimeObject) {
            JSTemporalZonedDateTimeObject zonedDateTime = (JSTemporalZonedDateTimeObject)((Object)value);
            valueIsZonedDateTime.enter((Node)this);
            return ToRelativeTemporalObjectNode.zonedDateTime(zonedDateTime);
        }
        if (valueIsObject.profile((Node)this, isObjectNode.executeBoolean(value))) {
            if (valueIsPlainDateTime.profile((Node)this, value instanceof JSTemporalPlainDateTimeObject)) {
                JSTemporalPlainDateTimeObject pd = (JSTemporalPlainDateTimeObject)((Object)value);
                return ToRelativeTemporalObjectNode.plainDate(JSTemporalPlainDate.create(ctx, realm, pd.getYear(), pd.getMonth(), pd.getDay(), pd.getCalendar(), this, errorBranch));
            }
            calendar = getTemporalCalendarWithISODefaultNode.execute(value);
            JSObject fields = TemporalUtil.prepareCalendarFields(ctx, calendar, value, TemporalUtil.listDMMCY, TemporalUtil.listTimeUnitsOffsetTZ, TemporalUtil.listEmpty);
            result = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, TemporalUtil.Overflow.CONSTRAIN, dateFromFieldsNode);
            Object timeZoneTemp = this.getTimeZoneNode.getValue((Object)fields);
            if (timeZoneTemp != Undefined.instance) {
                timeZone = (TruffleString)timeZoneTemp;
            }
            if ((offsetString = this.getOffsetNode.getValue((Object)fields)) == Undefined.instance) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            }
        } else if (value instanceof TruffleString) {
            JSTemporalParserRecord rec;
            TruffleString string = (TruffleString)value;
            ParseISODateTimeResult resultZDT = TemporalUtil.parseTemporalRelativeToString(string);
            result = resultZDT;
            offsetString = resultZDT.getTimeZoneResult().getOffsetString();
            TruffleString timeZoneName = resultZDT.getTimeZoneResult().getName();
            if (timeZoneName != null) {
                timeZone = toTimeZoneIdentifier.execute(timeZoneName);
            }
            if (resultZDT.getTimeZoneResult().isZ()) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.EXACT;
            } else if (offsetString == null) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            }
            matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_MINUTES;
            if (offsetString != null && (rec = TemporalUtil.parseTimeZoneOffsetStringHelper(offsetString)).hasOffsetSecond()) {
                matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
            }
            if ((calendar = result.getCalendar()) == null) {
                calendar = TemporalConstants.ISO8601;
            } else {
                String calendarJLS = toJavaString.execute((AbstractTruffleString)calendar);
                calendar = Strings.fromJavaString(fromJavaString, IntlUtil.canonicalizeCalendar(calendarJLS));
            }
        } else {
            errorBranch.enter((Node)this);
            throw Errors.createTypeErrorNotAString(value);
        }
        if (timeZoneAvailable.profile((Node)this, timeZone != null)) {
            long offsetNs = offsetBehaviour == TemporalUtil.OffsetBehaviour.OPTION ? TemporalUtil.parseTimeZoneOffsetString(offsetString) : 0L;
            BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), offsetBehaviour, offsetNs, timeZone, TemporalUtil.Disambiguation.COMPATIBLE, TemporalUtil.OffsetOption.REJECT, matchBehaviour);
            return ToRelativeTemporalObjectNode.zonedDateTime(JSTemporalZonedDateTime.create(ctx, realm, epochNanoseconds, timeZone, calendar));
        }
        return ToRelativeTemporalObjectNode.plainDate(JSTemporalPlainDate.create(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), calendar, this, errorBranch));
    }

    private static Result none() {
        return new Result(null, null);
    }

    private static Result plainDate(JSTemporalPlainDateObject plainDate) {
        return new Result(plainDate, null);
    }

    private static Result zonedDateTime(JSTemporalZonedDateTimeObject zonedDateTime) {
        return new Result(null, zonedDateTime);
    }

    public record Result(JSTemporalPlainDateObject plainRelativeTo, JSTemporalZonedDateTimeObject zonedRelativeTo) {
    }
}

