/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyObjectGetIterNodeGen;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached
@GenerateInline(inlineByDefault=true)
public abstract class PyObjectGetIter
extends Node {
    public static Object executeUncached(Object obj) {
        return PyObjectGetIterNodeGen.getUncached().execute(null, null, obj);
    }

    public final Object executeCached(Frame frame, Object receiver) {
        return this.execute(frame, this, receiver);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3);

    @Specialization
    static Object getIterRange(PIntRange object, @Bind PythonLanguage language) {
        return PFactory.createIntRangeIterator(language, object);
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    static Object getIter(VirtualFrame frame, Node inliningTarget, Object receiver, @Cached GetClassNode getReceiverClass, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached PySequenceCheckNode sequenceCheckNode, @Cached PRaiseNode raise, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callSlot, @Cached PyIterCheckNode checkNode) {
        Object type = getReceiverClass.execute(inliningTarget, receiver);
        TpSlots slots = getSlots.execute(inliningTarget, type);
        if (slots.tp_iter() != null) {
            Object result = callSlot.execute(frame, inliningTarget, slots.tp_iter(), receiver);
            if (!checkNode.execute(inliningTarget, result)) {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NONITER, result);
            }
            return result;
        }
        if (sequenceCheckNode.execute(inliningTarget, receiver)) {
            return PFactory.createSequenceIterator(PythonLanguage.get(inliningTarget), receiver);
        }
        throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, receiver);
    }

    @NeverDefault
    public static PyObjectGetIter create() {
        return PyObjectGetIterNodeGen.create();
    }

    public static PyObjectGetIter getUncached() {
        return PyObjectGetIterNodeGen.getUncached();
    }
}

