﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/ssm/model/OutputSource.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {

/**
 * <p>Includes information about the specified association execution.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AssociationExecutionTarget">AWS
 * API Reference</a></p>
 */
class AssociationExecutionTarget {
 public:
  AWS_SSM_API AssociationExecutionTarget() = default;
  AWS_SSM_API AssociationExecutionTarget(Aws::Utils::Json::JsonView jsonValue);
  AWS_SSM_API AssociationExecutionTarget& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SSM_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The association ID.</p>
   */
  inline const Aws::String& GetAssociationId() const { return m_associationId; }
  inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }
  template <typename AssociationIdT = Aws::String>
  void SetAssociationId(AssociationIdT&& value) {
    m_associationIdHasBeenSet = true;
    m_associationId = std::forward<AssociationIdT>(value);
  }
  template <typename AssociationIdT = Aws::String>
  AssociationExecutionTarget& WithAssociationId(AssociationIdT&& value) {
    SetAssociationId(std::forward<AssociationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The association version.</p>
   */
  inline const Aws::String& GetAssociationVersion() const { return m_associationVersion; }
  inline bool AssociationVersionHasBeenSet() const { return m_associationVersionHasBeenSet; }
  template <typename AssociationVersionT = Aws::String>
  void SetAssociationVersion(AssociationVersionT&& value) {
    m_associationVersionHasBeenSet = true;
    m_associationVersion = std::forward<AssociationVersionT>(value);
  }
  template <typename AssociationVersionT = Aws::String>
  AssociationExecutionTarget& WithAssociationVersion(AssociationVersionT&& value) {
    SetAssociationVersion(std::forward<AssociationVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The execution ID.</p>
   */
  inline const Aws::String& GetExecutionId() const { return m_executionId; }
  inline bool ExecutionIdHasBeenSet() const { return m_executionIdHasBeenSet; }
  template <typename ExecutionIdT = Aws::String>
  void SetExecutionId(ExecutionIdT&& value) {
    m_executionIdHasBeenSet = true;
    m_executionId = std::forward<ExecutionIdT>(value);
  }
  template <typename ExecutionIdT = Aws::String>
  AssociationExecutionTarget& WithExecutionId(ExecutionIdT&& value) {
    SetExecutionId(std::forward<ExecutionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource ID, for example, the managed node ID where the association
   * ran.</p>
   */
  inline const Aws::String& GetResourceId() const { return m_resourceId; }
  inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }
  template <typename ResourceIdT = Aws::String>
  void SetResourceId(ResourceIdT&& value) {
    m_resourceIdHasBeenSet = true;
    m_resourceId = std::forward<ResourceIdT>(value);
  }
  template <typename ResourceIdT = Aws::String>
  AssociationExecutionTarget& WithResourceId(ResourceIdT&& value) {
    SetResourceId(std::forward<ResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource type, for example, EC2.</p>
   */
  inline const Aws::String& GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  template <typename ResourceTypeT = Aws::String>
  void SetResourceType(ResourceTypeT&& value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = std::forward<ResourceTypeT>(value);
  }
  template <typename ResourceTypeT = Aws::String>
  AssociationExecutionTarget& WithResourceType(ResourceTypeT&& value) {
    SetResourceType(std::forward<ResourceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The association execution status.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  AssociationExecutionTarget& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Detailed information about the execution status.</p>
   */
  inline const Aws::String& GetDetailedStatus() const { return m_detailedStatus; }
  inline bool DetailedStatusHasBeenSet() const { return m_detailedStatusHasBeenSet; }
  template <typename DetailedStatusT = Aws::String>
  void SetDetailedStatus(DetailedStatusT&& value) {
    m_detailedStatusHasBeenSet = true;
    m_detailedStatus = std::forward<DetailedStatusT>(value);
  }
  template <typename DetailedStatusT = Aws::String>
  AssociationExecutionTarget& WithDetailedStatus(DetailedStatusT&& value) {
    SetDetailedStatus(std::forward<DetailedStatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date of the last execution.</p>
   */
  inline const Aws::Utils::DateTime& GetLastExecutionDate() const { return m_lastExecutionDate; }
  inline bool LastExecutionDateHasBeenSet() const { return m_lastExecutionDateHasBeenSet; }
  template <typename LastExecutionDateT = Aws::Utils::DateTime>
  void SetLastExecutionDate(LastExecutionDateT&& value) {
    m_lastExecutionDateHasBeenSet = true;
    m_lastExecutionDate = std::forward<LastExecutionDateT>(value);
  }
  template <typename LastExecutionDateT = Aws::Utils::DateTime>
  AssociationExecutionTarget& WithLastExecutionDate(LastExecutionDateT&& value) {
    SetLastExecutionDate(std::forward<LastExecutionDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The location where the association details are saved.</p>
   */
  inline const OutputSource& GetOutputSource() const { return m_outputSource; }
  inline bool OutputSourceHasBeenSet() const { return m_outputSourceHasBeenSet; }
  template <typename OutputSourceT = OutputSource>
  void SetOutputSource(OutputSourceT&& value) {
    m_outputSourceHasBeenSet = true;
    m_outputSource = std::forward<OutputSourceT>(value);
  }
  template <typename OutputSourceT = OutputSource>
  AssociationExecutionTarget& WithOutputSource(OutputSourceT&& value) {
    SetOutputSource(std::forward<OutputSourceT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_associationId;

  Aws::String m_associationVersion;

  Aws::String m_executionId;

  Aws::String m_resourceId;

  Aws::String m_resourceType;

  Aws::String m_status;

  Aws::String m_detailedStatus;

  Aws::Utils::DateTime m_lastExecutionDate{};

  OutputSource m_outputSource;
  bool m_associationIdHasBeenSet = false;
  bool m_associationVersionHasBeenSet = false;
  bool m_executionIdHasBeenSet = false;
  bool m_resourceIdHasBeenSet = false;
  bool m_resourceTypeHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_detailedStatusHasBeenSet = false;
  bool m_lastExecutionDateHasBeenSet = false;
  bool m_outputSourceHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
