#ifndef IMAP_RESP_CODE_H
#define IMAP_RESP_CODE_H

/* IMAP response codes (RFC 5530)) */
#define IMAP_RESP_CODE_UNAVAILABLE "UNAVAILABLE"
#define IMAP_RESP_CODE_AUTHFAILED "AUTHENTICATIONFAILED"
#define IMAP_RESP_CODE_AUTHZFAILED "AUTHORIZATIONFAILED"
#define IMAP_RESP_CODE_EXPIRED "EXPIRED"
#define IMAP_RESP_CODE_PRIVACYREQUIRED "PRIVACYREQUIRED"
#define IMAP_RESP_CODE_CONTACTADMIN "CONTACTADMIN"
#define IMAP_RESP_CODE_NOPERM "NOPERM"
#define IMAP_RESP_CODE_INUSE "INUSE"
#define IMAP_RESP_CODE_EXPUNGEISSUED "EXPUNGEISSUED"
#define IMAP_RESP_CODE_CORRUPTION "CORRUPTION"
#define IMAP_RESP_CODE_SERVERBUG "SERVERBUG"
#define IMAP_RESP_CODE_CLIENTBUG "CLIENTBUG"
#define IMAP_RESP_CODE_CANNOT "CANNOT"
#define IMAP_RESP_CODE_LIMIT "LIMIT"
#define IMAP_RESP_CODE_OVERQUOTA "OVERQUOTA"
#define IMAP_RESP_CODE_ALREADYEXISTS "ALREADYEXISTS"
#define IMAP_RESP_CODE_NONEXISTENT "NONEXISTENT"

/* IMAP response codes (RFC3516-RFC9051) */
#define IMAP_RESP_CODE_UNKNOWN_CTE "UNKNOWN-CTE" /* BINARY */

/* IMAP response codes (RFC3501-RFC9051) */
#define IMAP_RESP_CODE_PARSE "PARSE"
#define IMAP_RESP_CODE_ALERT "ALERT"
#define IMAP_RESP_CODE_BADCHARSET "BADCHARSET"
#define IMAP_RESP_CODE_CAPABILITY "CAPABILITY"
#define IMAP_RESP_CODE_PERMFLAGS "PERMANENTFLAGS"
#define IMAP_RESP_CODE_READONLY "READ-ONLY"
#define IMAP_RESP_CODE_READWRITE "READ-WRITE"
#define IMAP_RESP_CODE_TRYCREATE "TRYCREATE"
#define IMAP_RESP_CODE_UIDNEXT "UIDNEXT"
#define IMAP_RESP_CODE_UIDVALIDITY "UIDVALIDITY"
#define IMAP_RESP_CODE_UNSEEN "UNSEEN"
#define IMAP_RESP_CODE_APPENDUID "APPENDUID"
#define IMAP_RESP_CODE_COPYUID "COPYUID"
#define IMAP_RESP_CODE_UIDNOTSTICKY "UIDNOTSTICKY"

/* IMAP response codes (RFC2221) */
#define IMAP_RESP_CODE_REFERRAL "REFERRAL"

/* IMAP response codes (RFC4467) */
#define IMAP_RESP_CODE_URLMECH "URLMECH"

/* IMAP response codes (RFC4469) */
#define IMAP_RESP_CODE_BADURL "BADURL"
#define IMAP_RESP_CODE_TOOBIG "TOOBIG"

/* IMAP response codes (RFC4551) */
#define IMAP_RESP_CODE_HIGHESTMODSEQ "HIGHESTMODSEQ"
#define IMAP_RESP_CODE_MODIFIED "MODIFIED"
#define IMAP_RESP_CODE_NOMODSEQ "NOMODSEQ"

/* IMAP response codes (RFC4978) */
#define IMAP_RESP_CODE_COMPRESSIONACTIVE "COMPRESSIONACTIVE"

/* IMAP response codes (RFC5162-RFC9051) */
#define IMAP_RESP_CODE_CLOSED "CLOSED"

/* IMAP response codes (RFC5182) */
#define IMAP_RESP_CODE_NOTSAVED "NOTSAVED"

/* IMAP response codes (RFC5255) */
#define IMAP_RESP_CODE_BADCOMPARATOR "BADCOMPARATOR"

/* IMAP response codes (RFC5257) */
#define IMAP_RESP_CODE_ANNOTATE "ANNOTATE"
#define IMAP_RESP_CODE_ANNOTATIONS "ANNOTATIONS"

/* IMAP response codes (RFC5259) */
#define IMAP_RESP_CODE_MAXCONVERTMESSAGES "MAXCONVERTMESSAGES"
#define IMAP_RESP_CODE_MAXCONVERTPARTS "MAXCONVERTPARTS"
#define IMAP_RESP_CODE_TEMPFAIL "TEMPFAIL"

/* IMAP response codes (RFC5267) */
#define IMAP_RESP_CODE_NOUPDATE "NOUPDATE"

/* IMAP response codes (RFC5464) */
#define IMAP_RESP_CODE_METADATA "METADATA"

/* IMAP response codes (RFC5465) */
#define IMAP_RESP_CODE_BADEVENT "BADEVENT"
#define IMAP_RESP_CODE_NOTIFICATIONOVERFLOW "NOTIFICATIONOVERFLOW"

/* IMAP response codes (RFC5466) */
#define IMAP_RESP_CODE_UNDEFINED_FILTER "UNDEFINED-FILTER"

/* IMAP response codes (RFC6154) */
#define IMAP_RESP_CODE_USEATTR "USEATTR"

/* IMAP response codes (RFC6858) */
#define IMAP_RESP_CODE_DOWNGRADED "DOWNGRADED"

/* IMAP response codes (RFC8474) */
#define IMAP_RESP_CODE_MAILBOXID "MAILBOXID"

/* IMAP response codes (RFC9051) */
#define IMAP_RESP_CODE_HASCHILDREN "HASCHILDREN"

/* IMAP response codes (RFC9585) */
#define IMAP_RESP_CODE_INPROGRESS "INPROGRESS"

/* IMAP response codes (RFC9586) */
#define IMAP_RESP_CODE_UIDREQUIRED "UIDREQUIRED"

#endif
