/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.freeze;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ReflectionUtils;
import com.tngtech.archunit.library.freeze.StoreInitializationFailedException;
import com.tngtech.archunit.library.freeze.TextFileBasedViolationStore;
import com.tngtech.archunit.library.freeze.ViolationStore;

class ViolationStoreFactory {
    static final String FREEZE_STORE_PROPERTY_NAME = "freeze.store";

    ViolationStoreFactory() {
    }

    static ViolationStore create() {
        return ArchConfiguration.get().containsProperty(FREEZE_STORE_PROPERTY_NAME) ? ViolationStoreFactory.createInstance(ArchConfiguration.get().getProperty(FREEZE_STORE_PROPERTY_NAME)) : new TextFileBasedViolationStore();
    }

    @MayResolveTypesViaReflection(reason="This is not part of the import process")
    private static ViolationStore createInstance(String violationStoreClassName) {
        try {
            return (ViolationStore)ReflectionUtils.newInstanceOf(Class.forName(violationStoreClassName), new Object[0]);
        }
        catch (Exception e) {
            String message = String.format("Could not instantiate %s of configured type '%s=%s'", ViolationStore.class.getSimpleName(), FREEZE_STORE_PROPERTY_NAME, violationStoreClassName);
            throw new StoreInitializationFailedException(message, e);
        }
    }
}

