/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.engine.discovery.predicates.IsInnerClass;
import org.junit.platform.commons.support.AnnotationSupport;

@API(status=API.Status.INTERNAL, since="5.0")
public class IsNestedTestClass
implements Predicate<Class<?>> {
    private static final IsInnerClass isInnerClass = new IsInnerClass();

    @Override
    public boolean test(Class<?> candidate) {
        if (!isInnerClass.test(candidate)) {
            return false;
        }
        return AnnotationSupport.isAnnotated(candidate, Nested.class);
    }
}

