/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractSymbolInternals;

public class DataSymbolInternals
extends AbstractSymbolInternals {
    protected RecordNumber typeRecordNumber;
    protected long offset;
    protected int segment;
    protected String name;
    private boolean emitToken;

    public static DataSymbolInternals parse16(AbstractPdb pdb, PdbByteReader reader, boolean emitToken) throws PdbException {
        DataSymbolInternals result = new DataSymbolInternals(pdb, emitToken);
        result.offset = reader.parseVarSizedOffset(16);
        result.segment = pdb.parseSegment(reader);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        reader.align4();
        return result;
    }

    public static DataSymbolInternals parse32(AbstractPdb pdb, PdbByteReader reader, boolean emitToken) throws PdbException {
        DataSymbolInternals result = new DataSymbolInternals(pdb, emitToken);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.offset = reader.parseVarSizedOffset(32);
        result.segment = pdb.parseSegment(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        reader.align4();
        return result;
    }

    public static DataSymbolInternals parse3216(AbstractPdb pdb, PdbByteReader reader, boolean emitToken) throws PdbException {
        DataSymbolInternals result = new DataSymbolInternals(pdb, emitToken);
        result.offset = reader.parseVarSizedOffset(32);
        result.segment = pdb.parseSegment(reader);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        reader.align4();
        return result;
    }

    public static DataSymbolInternals parse32St(AbstractPdb pdb, PdbByteReader reader, boolean emitToken) throws PdbException {
        DataSymbolInternals result = new DataSymbolInternals(pdb, emitToken);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.offset = reader.parseVarSizedOffset(32);
        result.segment = pdb.parseSegment(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        reader.align4();
        return result;
    }

    public DataSymbolInternals(AbstractPdb pdb, boolean emitToken) {
        super(pdb);
        this.emitToken = emitToken;
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSegment() {
        return this.segment;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        if (this.emitToken) {
            builder.append(String.format(": [%04X:%08X], Token: %08X, %s", this.segment, this.offset, this.typeRecordNumber.getNumber(), this.name));
        } else {
            builder.append(String.format(": [%04X:%08X], Type: %s, %s", this.segment, this.offset, this.pdb.getTypeRecord(this.typeRecordNumber), this.name));
        }
    }
}

