/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ApplicationThemeManager;
import generic.theme.laf.FlatLookAndFeelManager;
import generic.theme.laf.GtkLookAndFeelManager;
import generic.theme.laf.LookAndFeelManager;
import generic.theme.laf.MacLookAndFeelManager;
import generic.theme.laf.MetalLookAndFeelManager;
import generic.theme.laf.MotifLookAndFeelManager;
import generic.theme.laf.NimbusLookAndFeelManager;
import generic.theme.laf.WindowsClassicLookAndFeelManager;
import generic.theme.laf.WindowsLookAndFeelManager;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.exception.AssertException;
import javax.swing.UIManager;

public enum LafType {
    METAL("Metal"),
    NIMBUS("Nimbus"),
    GTK("GTK+"),
    MOTIF("CDE/Motif"),
    FLAT_LIGHT("Flat Light"),
    FLAT_DARK("Flat Dark", true),
    WINDOWS("Windows"),
    WINDOWS_CLASSIC("Windows Classic"),
    MAC("Mac OS X");

    private String name;
    private boolean usesDarkDefaults;

    private LafType(String name) {
        this(name, false);
    }

    private LafType(String name, boolean usesDarkDefaults) {
        this.name = name;
        this.usesDarkDefaults = usesDarkDefaults;
    }

    public String getDisplayString() {
        if (this == MOTIF) {
            return "Motif";
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean usesDarkDefaults() {
        return this.usesDarkDefaults;
    }

    public static LafType fromName(String name) {
        for (LafType type : LafType.values()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public boolean isSupported() {
        UIManager.LookAndFeelInfo[] installedLookAndFeels;
        for (UIManager.LookAndFeelInfo info : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
            if (!this.name.equals(info.getName())) continue;
            return true;
        }
        return false;
    }

    public LookAndFeelManager getLookAndFeelManager(ApplicationThemeManager themeManager) {
        return LafType.createManager(this, themeManager);
    }

    private static LookAndFeelManager createManager(LafType type, ApplicationThemeManager themeManager) {
        switch (type.ordinal()) {
            case 8: {
                return new MacLookAndFeelManager(themeManager);
            }
            case 0: {
                return new MetalLookAndFeelManager(themeManager);
            }
            case 6: {
                return new WindowsLookAndFeelManager(themeManager);
            }
            case 7: {
                return new WindowsClassicLookAndFeelManager(themeManager);
            }
            case 2: {
                return new GtkLookAndFeelManager(themeManager);
            }
            case 3: {
                return new MotifLookAndFeelManager(themeManager);
            }
            case 1: {
                return new NimbusLookAndFeelManager(themeManager);
            }
            case 4: 
            case 5: {
                return new FlatLookAndFeelManager(type, themeManager);
            }
        }
        throw new AssertException("No lookAndFeelManager defined for " + String.valueOf((Object)type));
    }

    public static LafType getDefaultLookAndFeel() {
        OperatingSystem OS = Platform.CURRENT_PLATFORM.getOperatingSystem();
        return switch (OS) {
            case OperatingSystem.MAC_OS_X -> MAC;
            case OperatingSystem.WINDOWS -> WINDOWS;
            default -> FLAT_LIGHT;
        };
    }

    public String toString() {
        return this.getDisplayString();
    }
}

