/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class TarjanStronglyConnectedAlgorthm<V, E extends GEdge<V>> {
    private GDirectedGraph<V, E> graph;
    private Map<V, TarjanVertexInfo> vertexToInfos = new HashMap<V, TarjanVertexInfo>();
    private Stack<V> stack = new Stack();
    private Set<V> set = new HashSet<V>();
    private Set<Set<V>> stronglyConnectedList = new HashSet<Set<V>>();

    public TarjanStronglyConnectedAlgorthm(GDirectedGraph<V, E> g) {
        this.graph = g;
        this.compute();
    }

    private void compute() {
        for (V v : this.graph.getVertices()) {
            if (this.vertexToInfos.containsKey(v)) continue;
            this.strongConnect(v);
        }
    }

    private TarjanVertexInfo strongConnect(V v) {
        TarjanVertexInfo vInfo = new TarjanVertexInfo();
        this.vertexToInfos.put((TarjanVertexInfo)v, vInfo);
        this.push(v);
        for (GEdge edge : this.graph.getOutEdges(v)) {
            Object w = edge.getEnd();
            TarjanVertexInfo wInfo = this.vertexToInfos.get(w);
            if (wInfo == null) {
                wInfo = this.strongConnect(w);
                vInfo.lowLink = Math.min(vInfo.lowLink, wInfo.lowLink);
                continue;
            }
            if (!this.set.contains(w)) continue;
            vInfo.lowLink = Math.min(vInfo.lowLink, wInfo.index);
        }
        if (vInfo.lowLink == vInfo.index) {
            HashSet<V> connectedSet = new HashSet<V>();
            connectedSet.add(v);
            V w = this.pop();
            while (v != w) {
                connectedSet.add(w);
                w = this.pop();
            }
            this.stronglyConnectedList.add(connectedSet);
        }
        return vInfo;
    }

    private void push(V v) {
        this.stack.push(v);
        this.set.add(v);
    }

    private V pop() {
        V v = this.stack.pop();
        this.set.remove(v);
        return v;
    }

    public Set<Set<V>> getConnectedComponents() {
        return this.stronglyConnectedList;
    }

    static class TarjanVertexInfo {
        private static int nextIndex = 0;
        public int index;
        public int lowLink;

        public TarjanVertexInfo() {
            this.lowLink = this.index = nextIndex++;
        }
    }
}

