/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import edu.uci.ics.jung.algorithms.layout.Layout;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGView;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.graph.viewer.GraphViewer;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractGraphComponentPanel
extends JPanel {
    protected FGController controller;
    protected FGVertex vertex;
    protected String title;
    private boolean isShowingOverride = true;
    private boolean isFocused;

    AbstractGraphComponentPanel(FGController controller, FGVertex vertex) {
        this.controller = controller;
        this.vertex = vertex;
    }

    void setShowing(boolean isShowing) {
        this.isShowingOverride = isShowing;
    }

    String getTitle() {
        return this.title;
    }

    @Override
    public boolean isShowing() {
        return this.isShowingOverride;
    }

    @Override
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    FGController getController() {
        return this.controller;
    }

    void dispose() {
        this.controller = null;
        this.vertex = null;
    }

    protected void groupVertices() {
        FGView view = this.controller.getView();
        GraphViewer primaryViewer = view.getPrimaryGraphViewer();
        Layout graphLayout = primaryViewer.getGraphLayout();
        Point2D location = (Point2D)graphLayout.apply((Object)this.vertex);
        this.controller.groupSelectedVertices(location);
    }

    protected void regroupVertices() {
        this.controller.regroupVertices(this.vertex);
    }

    abstract Color getBackgroundColor();

    abstract Color getSelectionColor();

    abstract Color getUserDefinedColor();

    abstract Color getDefaultBackgroundColor();

    abstract void clearColor();

    abstract JComponent getHeader();

    @Override
    public abstract String getToolTipText(MouseEvent var1);

    abstract ListingModel getListingModel(Address var1);

    abstract JComponent getToolTipComponentForEdge(FGEdge var1);

    abstract JComponent getToolTipComponentForVertex();

    abstract boolean isSelected();

    abstract void setSelected(boolean var1);

    abstract void setCursorPosition(ProgramLocation var1);

    abstract Rectangle getCursorBounds();

    abstract void setProgramSelection(ProgramSelection var1);

    abstract ProgramSelection getProgramSelection();

    abstract String getTextSelection();

    abstract void setProgramHighlight(ProgramSelection var1);

    void setProgramLocation(ProgramLocation location) {
        this.setSelected(true);
        this.setCursorPosition(location);
    }

    abstract ProgramLocation getProgramLocation();

    boolean isDefaultBackgroundColor() {
        return this.getBackgroundColor().equals(GThemeDefaults.Colors.BACKGROUND);
    }

    boolean isHeaderClick(Component clickedComponent) {
        if (clickedComponent == null) {
            return false;
        }
        JComponent header = this.getHeader();
        return SwingUtilities.isDescendingFrom(clickedComponent, header);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = super.getBounds();
        Dimension preferredSize = this.getPreferredSize();
        bounds.setSize(preferredSize);
        return bounds;
    }

    abstract void setBackgroundColor(Color var1);

    abstract void restoreColor(Color var1);

    @Override
    public String toString() {
        return this.getTitle();
    }

    abstract void refreshModel();

    abstract void refreshDisplay();

    abstract void refreshDisplayForAddress(Address var1);

    abstract Component getMaximizedViewComponent();

    abstract boolean isFullScreenMode();

    abstract void setFullScreenMode(boolean var1);

    abstract void updateGroupAssociationStatus(boolean var1);

    abstract void editLabel(JComponent var1);

    public void setFocused(boolean focused) {
        this.isFocused = focused;
        this.doSetFocused(focused);
    }

    abstract void doSetFocused(boolean var1);

    public boolean isFocused() {
        return this.isFocused;
    }
}

