/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.actions;

import docking.action.KeyBindingType;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;

public abstract class AbstractFindReferencesToAddressAction
extends NavigatableContextAction {
    public static final String NAME = "Show References To Address";
    private static final String HELP_TOPIC = "LocationReferencesPlugin";
    private PluginTool tool;

    protected AbstractFindReferencesToAddressAction(PluginTool tool, String owner) {
        super(NAME, owner, KeyBindingType.SHARED);
        this.tool = tool;
        this.setDescription("Shows references to the current Instruction or Data");
        this.setHelpLocation(new HelpLocation(HELP_TOPIC, "Show_Refs_To_Code_Unit"));
    }

    @Override
    public void actionPerformed(NavigatableActionContext context) {
        LocationReferencesService service = (LocationReferencesService)this.tool.getService(LocationReferencesService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)("The " + LocationReferencesService.class.getSimpleName() + " is not installed.\nPlease add the plugin implementing this service."));
            return;
        }
        Program program = context.getProgram();
        ProgramLocation location = this.getLocation(context);
        Address address = location.getAddress();
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(address);
        int[] path = location.getComponentPath();
        if (cu instanceof Data) {
            Data outerData = (Data)cu;
            Data data = outerData.getComponent(location.getComponentPath());
            address = data.getMinAddress();
        }
        AddressFieldLocation addressLocation = new AddressFieldLocation(program, address, path, address.toString(), 0);
        service.showReferencesToLocation((ProgramLocation)addressLocation, context.getNavigatable());
    }

    @Override
    protected boolean isEnabledForContext(NavigatableActionContext context) {
        Program program = context.getProgram();
        ProgramLocation location = this.getLocation(context);
        if (location == null) {
            return false;
        }
        Address address = location.getAddress();
        if (address == null) {
            return false;
        }
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(address);
        return cu != null;
    }

    protected ProgramLocation getLocation(NavigatableActionContext context) {
        return context.getLocation();
    }
}

