/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.OptionDialog;
import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.SpacerFieldLocation;
import ghidra.util.StringUtilities;
import java.awt.Color;
import java.math.BigInteger;

public class SpacerFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Spacer";
    private String text = null;

    public SpacerFieldFactory() {
        super(FIELD_NAME);
    }

    private SpacerFieldFactory(FieldFormatModel model, ListingHighlightProvider hsProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hsProvider, displayOptions, fieldOptions);
    }

    public SpacerFieldFactory(String text, FieldFormatModel model, ListingHighlightProvider hsProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hsProvider, displayOptions, fieldOptions);
        this.text = text;
    }

    public void setText(String text) {
        if (text != null && text.length() == 0) {
            text = null;
        }
        this.text = text;
    }

    public void setText() {
        String newText = OptionDialog.showInputSingleLineDialog(null, (String)"Input Spacer Text", (String)"Text", (String)this.text);
        if (newText != null) {
            this.text = (newText = newText.trim()).equals("") ? null : newText;
        }
        this.model.update();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        if (this.enabled && this.text != null) {
            AttributedString as = new AttributedString(this.text, (Color)ListingColors.SEPARATOR, this.getMetrics());
            TextFieldElement field = new TextFieldElement(as, 0, 0);
            return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)field, this.startX + varWidth, this.width, this.hlProvider);
        }
        return null;
    }

    @Override
    public String getFieldText() {
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof SpacerFieldLocation)) {
            return null;
        }
        SpacerFieldLocation loc = (SpacerFieldLocation)programLoc;
        if (loc.getText().equals(this.text)) {
            return new FieldLocation(index, fieldNum, 0, loc.getCharOffset());
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        int[] cpath = null;
        if (obj instanceof Data) {
            cpath = ((Data)obj).getComponentPath();
        }
        return new SpacerFieldLocation(cu.getProgram(), cu.getMinAddress(), cpath, col, this.text);
    }

    public String getStringToHighlight(ListingTextField bf, int row, int col, ProgramLocation loc) {
        if (loc == null) {
            return null;
        }
        String s = ((SpacerFieldLocation)loc).getText();
        return StringUtilities.findWord((String)s, (int)col);
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return true;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions options, ToolOptions fieldOptions) {
        return new SpacerFieldFactory(formatModel, provider, (Options)options, (Options)fieldOptions);
    }
}

