/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import java.util.LinkedList;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.hfsexplorer.partitioning.PartitionSystem;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.ps.ebr.ExtendedBootRecord;

public class DOSExtendedPartitionSystem
implements PartitionSystem {
    private final ExtendedBootRecord[] extendedBootRecords;

    public DOSExtendedPartitionSystem(ReadableRandomAccessStream llf, long extendedPartitionOffset, long extendedPartitionLength, int sectorSize) {
        LinkedList<ExtendedBootRecord> recordList = new LinkedList<ExtendedBootRecord>();
        byte[] block = new byte[sectorSize];
        long seekLocation = extendedPartitionOffset;
        if (seekLocation > extendedPartitionOffset + extendedPartitionLength) {
            throw new RuntimeException("Invalid DOS Extended partition system (seekLocation=" + seekLocation + ").");
        }
        llf.seek(seekLocation);
        llf.readFully(block);
        ExtendedBootRecord ebr = new ExtendedBootRecord(block, 0, extendedPartitionOffset, seekLocation, sectorSize);
        recordList.addLast(ebr);
        boolean i = false;
        while (ebr.getSecondEntry().getLBAPartitionLength() != 0 || ebr.getSecondEntry().getLBAFirstSector() != 0) {
            seekLocation = ebr.getSecondEntry().getStartOffset();
            if (seekLocation > extendedPartitionOffset + extendedPartitionLength) {
                throw new RuntimeException("Invalid DOS Extended partition system (seekLocation=" + seekLocation + ").");
            }
            llf.seek(seekLocation);
            llf.readFully(block);
            ebr = new ExtendedBootRecord(block, 0, extendedPartitionOffset, seekLocation, sectorSize);
            recordList.addLast(ebr);
        }
        this.extendedBootRecords = recordList.toArray(new ExtendedBootRecord[recordList.size()]);
    }

    public boolean isValid() {
        for (ExtendedBootRecord ebr : this.extendedBootRecords) {
            if (ebr.isValid()) continue;
            return false;
        }
        return true;
    }

    public int getPartitionCount() {
        return this.extendedBootRecords.length;
    }

    public int getUsedPartitionCount() {
        return this.getPartitionCount();
    }

    public Partition getPartitionEntry(int index) {
        return this.extendedBootRecords[index].getFirstEntry();
    }

    public Partition[] getPartitionEntries() {
        Partition[] result = new Partition[this.extendedBootRecords.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.extendedBootRecords[i].getFirstEntry();
        }
        return result;
    }

    public Partition[] getUsedPartitionEntries() {
        return this.getPartitionEntries();
    }

    public String getLongName() {
        return "DOS Extended";
    }

    public String getShortName() {
        return "EBR";
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " extendedBootRecords:");
        for (int i = 0; i < this.extendedBootRecords.length; ++i) {
            ps.println(prefix + "  [" + i + "]:");
            this.extendedBootRecords[i].print(ps, prefix + "   ");
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix);
    }
}

