/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.transform.BidirectionalTransformer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.jungrapht.visualization.transform.shape.ShapeTransformer;
import org.jungrapht.visualization.transform.shape.TransformingGraphics;

public class HeavyweightVertexLabelRenderer<V, E>
implements Renderer.VertexLabel<V, E> {
    private Renderer.VertexLabel.Positioner positioner = new OutsidePositioner();

    public Component prepareRenderer(RenderContext<V, E> renderContext, Object value, boolean isSelected, V vertex) {
        return renderContext.getVertexLabelRenderer().getVertexLabelRendererComponent(renderContext.getScreenDevice(), value, renderContext.getVertexFontFunction().apply(vertex), isSelected, vertex);
    }

    @Override
    public void labelVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v, String label) {
        Point p;
        BidirectionalTransformer transformer;
        if (!renderContext.getVertexIncludePredicate().test(v)) {
            return;
        }
        Point pt = (Point)layoutModel.apply(v);
        Point2D pt2d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, pt.x, pt.y);
        float x = (float)pt2d.getX();
        float y = (float)pt2d.getY();
        Component component = this.prepareRenderer(renderContext, label, renderContext.getSelectedVertexState().isSelected(v), v);
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Dimension d = component.getPreferredSize();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        Shape shape = renderContext.getVertexShapeFunction().apply(v);
        shape = xform.createTransformedShape(shape);
        if (renderContext.getGraphicsContext() instanceof TransformingGraphics && (transformer = ((TransformingGraphics)renderContext.getGraphicsContext()).getTransformer()) instanceof ShapeTransformer) {
            ShapeTransformer shapeTransformer = (ShapeTransformer)transformer;
            shape = shapeTransformer.transform(shape);
        }
        Rectangle2D bounds = shape.getBounds2D();
        Renderer.VertexLabel.Position position = renderContext.getVertexLabelPosition();
        if (position == Renderer.VertexLabel.Position.AUTO) {
            Dimension vvd = renderContext.getScreenDevice().getSize();
            if (vvd.width == 0 || vvd.height == 0) {
                vvd = renderContext.getScreenDevice().getPreferredSize();
            }
            p = this.getAnchorPoint(bounds, d, this.positioner.getPosition(x, y, vvd));
        } else {
            p = this.getAnchorPoint(bounds, d, position);
        }
        Paint fillPaint = renderContext.getVertexLabelDrawPaintFunction().apply(v);
        if (fillPaint != null) {
            Color oldPaint = component.getForeground();
            component.setForeground((Color)fillPaint);
            g.draw(component, renderContext.getRendererPane(), (int)p.x, (int)p.y, d.width, d.height, true);
            component.setForeground(oldPaint);
        } else {
            g.draw(component, renderContext.getRendererPane(), (int)p.x, (int)p.y, d.width, d.height, true);
        }
    }

    protected Point getAnchorPoint(Rectangle2D vertexBounds, Dimension labelSize, Renderer.VertexLabel.Position position) {
        int offset = 5;
        switch (position) {
            case N: {
                double x = vertexBounds.getCenterX() - (double)labelSize.width / 2.0;
                double y = vertexBounds.getMinY() - (double)offset - (double)labelSize.height;
                return Point.of((double)x, (double)y);
            }
            case NE: {
                double x = vertexBounds.getMaxX() + (double)offset;
                double y = vertexBounds.getMinY() - (double)offset - (double)labelSize.height;
                return Point.of((double)x, (double)y);
            }
            case E: {
                double x = vertexBounds.getMaxX() + (double)offset;
                double y = vertexBounds.getCenterY() - (double)labelSize.height / 2.0;
                return Point.of((double)x, (double)y);
            }
            case SE: {
                double x = vertexBounds.getMaxX() + (double)offset;
                double y = vertexBounds.getMaxY() + (double)offset;
                return Point.of((double)x, (double)y);
            }
            case S: {
                double x = vertexBounds.getCenterX() - (double)labelSize.width / 2.0;
                double y = vertexBounds.getMaxY() + (double)offset;
                return Point.of((double)x, (double)y);
            }
            case SW: {
                double x = vertexBounds.getMinX() - (double)offset - (double)labelSize.width;
                double y = vertexBounds.getMaxY() + (double)offset;
                return Point.of((double)x, (double)y);
            }
            case W: {
                double x = vertexBounds.getMinX() - (double)offset - (double)labelSize.width;
                double y = vertexBounds.getCenterY() - (double)labelSize.height / 2.0;
                return Point.of((double)x, (double)y);
            }
            case NW: {
                double x = vertexBounds.getMinX() - (double)offset - (double)labelSize.width;
                double y = vertexBounds.getMinY() - (double)offset - (double)labelSize.height;
                return Point.of((double)x, (double)y);
            }
            case CNTR: {
                double x = vertexBounds.getCenterX() - (double)labelSize.width / 2.0;
                double y = vertexBounds.getCenterY() - (double)labelSize.height / 2.0;
                return Point.of((double)x, (double)y);
            }
        }
        return Point.ORIGIN;
    }

    @Override
    public Renderer.VertexLabel.Positioner getPositioner() {
        return this.positioner;
    }

    @Override
    public void setPositioner(Renderer.VertexLabel.Positioner positioner) {
        this.positioner = positioner;
    }

    public static class OutsidePositioner
    implements Renderer.VertexLabel.Positioner {
        @Override
        public Renderer.VertexLabel.Position getPosition(float x, float y, Dimension d) {
            int cx = d.width / 2;
            int cy = d.height / 2;
            if (x > (float)cx && y > (float)cy) {
                return Renderer.VertexLabel.Position.SE;
            }
            if (x > (float)cx && y < (float)cy) {
                return Renderer.VertexLabel.Position.NE;
            }
            if (x < (float)cx && y > (float)cy) {
                return Renderer.VertexLabel.Position.SW;
            }
            return Renderer.VertexLabel.Position.NW;
        }
    }

    public static class InsidePositioner
    implements Renderer.VertexLabel.Positioner {
        @Override
        public Renderer.VertexLabel.Position getPosition(float x, float y, Dimension d) {
            int cx = d.width / 2;
            int cy = d.height / 2;
            if (x > (float)cx && y > (float)cy) {
                return Renderer.VertexLabel.Position.NW;
            }
            if (x > (float)cx && y < (float)cy) {
                return Renderer.VertexLabel.Position.SW;
            }
            if (x < (float)cx && y > (float)cy) {
                return Renderer.VertexLabel.Position.NE;
            }
            return Renderer.VertexLabel.Position.SE;
        }
    }
}

