/*
 * Decompiled with CFR 0.152.
 */
package ghidra.closedpatternmining;

import java.util.List;

public class SequenceItem
implements Comparable<SequenceItem> {
    private String symbol;
    private int index;

    public SequenceItem(String item, int index) {
        if (item.length() != 1) {
            throw new IllegalArgumentException("frequent item " + item + " must be of length 1");
        }
        this.index = index;
        this.symbol = item;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.symbol.hashCode() + 31 * this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceItem other = (SequenceItem)obj;
        if (!other.getSymbol().equals(this.symbol)) {
            return false;
        }
        return other.getIndex() == this.index;
    }

    public static String getDittedString(List<SequenceItem> itemList, int totalLength) {
        StringBuilder sb = new StringBuilder();
        int symbolsWritten = 0;
        for (SequenceItem currentItem : itemList) {
            if (currentItem.getIndex() < symbolsWritten) {
                throw new IllegalArgumentException("itemList must be in ascending order of item index");
            }
            while (currentItem.getIndex() > symbolsWritten) {
                sb.append(".");
                ++symbolsWritten;
            }
            sb.append(currentItem.getSymbol());
            ++symbolsWritten;
        }
        if (symbolsWritten > totalLength) {
            throw new IllegalArgumentException("mismatch between itemList and totalLength");
        }
        while (symbolsWritten < totalLength) {
            sb.append(".");
            ++symbolsWritten;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("item: ");
        sb.append(this.symbol);
        sb.append(", index: ");
        sb.append(this.index);
        return sb.toString();
    }

    @Override
    public int compareTo(SequenceItem arg0) {
        if (this.index != arg0.getIndex()) {
            return this.index - arg0.getIndex();
        }
        return this.symbol.compareTo(arg0.getSymbol());
    }
}

