/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.emulator.memory;

import ghidra.app.emulator.memory.MemoryLoadImage;
import ghidra.pcode.memstate.MemoryPage;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CompositeLoadImage
implements MemoryLoadImage {
    private List<MemoryLoadImage> providers = new ArrayList<MemoryLoadImage>();
    private HashMap<MemoryLoadImage, AddressSetView> addrSets = new HashMap();

    public void addProvider(MemoryLoadImage provider, AddressSetView view) {
        if (view == null) {
            this.providers.add(this.providers.size(), provider);
        } else {
            this.providers.add(0, provider);
        }
        this.addrSets.put(provider, view);
    }

    @Override
    public byte[] loadFill(byte[] buf, int size, Address addr, int bufOffset, boolean generateInitializedMask) {
        Address endAddr = addr.add((long)(size - 1));
        for (MemoryLoadImage provider : this.providers) {
            AddressSetView view = this.addrSets.get(provider);
            if (view != null && !view.intersects(addr, endAddr)) continue;
            return provider.loadFill(buf, size, addr, bufOffset, generateInitializedMask);
        }
        return generateInitializedMask ? MemoryPage.getInitializedMask(size, false) : null;
    }

    @Override
    public void writeBack(byte[] bytes, int size, Address addr, int offset) {
        Address endAddr = addr.add((long)(size - 1));
        for (MemoryLoadImage provider : this.providers) {
            AddressSetView view = this.addrSets.get(provider);
            if (view != null && !view.intersects(addr, endAddr)) continue;
            provider.writeBack(bytes, size, addr, offset);
        }
    }

    @Override
    public void dispose() {
        for (MemoryLoadImage provider : this.providers) {
            provider.dispose();
        }
    }
}

