/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Monitorable;
import org.apache.kafka.common.metrics.internals.PluginMetricsImpl;
import org.apache.kafka.common.utils.Utils;

public class Plugin<T>
implements Supplier<T>,
AutoCloseable {
    private final T instance;
    private final Optional<PluginMetricsImpl> pluginMetrics;

    private Plugin(T instance, PluginMetricsImpl pluginMetrics) {
        this.instance = instance;
        this.pluginMetrics = Optional.ofNullable(pluginMetrics);
    }

    public static <T> Plugin<T> wrapInstance(T instance, Metrics metrics, Supplier<Map<String, String>> tagsSupplier) {
        PluginMetricsImpl pluginMetrics = null;
        if (instance instanceof Monitorable && metrics != null) {
            pluginMetrics = new PluginMetricsImpl(metrics, tagsSupplier.get());
            ((Monitorable)instance).withPluginMetrics(pluginMetrics);
        }
        return new Plugin<T>(instance, pluginMetrics);
    }

    public static <T> Plugin<T> wrapInstance(T instance, Metrics metrics, String key) {
        return Plugin.wrapInstance(instance, metrics, () -> Plugin.tags(key, instance));
    }

    public static <T> Plugin<T> wrapInstance(T instance, Metrics metrics, String key, String name, String value) {
        Supplier<Map<String, String>> tagsSupplier = () -> {
            Map<String, String> tags = Plugin.tags(key, instance);
            tags.put(name, value);
            return tags;
        };
        return Plugin.wrapInstance(instance, metrics, tagsSupplier);
    }

    private static <T> Map<String, String> tags(String key, T instance) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("config", key);
        tags.put("class", instance.getClass().getSimpleName());
        return tags;
    }

    public static <T> List<Plugin<T>> wrapInstances(List<T> instances, Metrics metrics, String key) {
        ArrayList<Plugin<T>> plugins = new ArrayList<Plugin<T>>();
        for (T instance : instances) {
            plugins.add(Plugin.wrapInstance(instance, metrics, key));
        }
        return plugins;
    }

    @Override
    public T get() {
        return this.instance;
    }

    @Override
    public void close() throws Exception {
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        if (this.instance instanceof AutoCloseable) {
            Utils.closeQuietly((AutoCloseable)this.instance, this.instance.getClass().getSimpleName(), firstException);
        }
        this.pluginMetrics.ifPresent(metrics -> Utils.closeQuietly((AutoCloseable)metrics, "pluginMetrics", firstException));
        Throwable throwable = (Throwable)firstException.get();
        if (throwable != null) {
            throw new KafkaException("failed closing plugin", throwable);
        }
    }
}

