/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import picocli.CommandLine;

public abstract class AbstractCommand
implements Callable<Integer> {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    protected Picocli picocli;

    protected void executionError(CommandLine cmd, String message) {
        this.executionError(cmd, message, null);
    }

    protected void executionError(CommandLine cmd, String message, Throwable cause) {
        Messages.cliExecutionError(cmd, message, cause);
    }

    public String getInitProfile() {
        String configuredProfile = org.keycloak.common.util.Environment.getProfile();
        if (configuredProfile != null) {
            return configuredProfile;
        }
        if (Environment.isRebuildCheck()) {
            return "prod";
        }
        return Optional.ofNullable(this.getDefaultProfile()).or(() -> Optional.ofNullable(PersistedConfigSource.getInstance().getValue("kc.profile"))).orElse("prod");
    }

    @Override
    public Integer call() {
        return this.callCommand().orElseGet(() -> {
            this.runCommand();
            return 0;
        });
    }

    protected Optional<Integer> callCommand() {
        return Optional.empty();
    }

    protected void runCommand() {
    }

    public boolean includeRuntime() {
        return false;
    }

    public boolean includeBuildTime() {
        return false;
    }

    public List<OptionCategory> getOptionCategories() {
        return Arrays.asList(OptionCategory.values());
    }

    protected void validateConfig() {
        this.picocli.validateConfig(ConfigArgsConfigSource.getAllCliArgs(), this);
    }

    public abstract String getName();

    public Optional<CommandLine> getCommandLine() {
        return Optional.ofNullable(this.spec).map(CommandLine.Model.CommandSpec::commandLine);
    }

    public void setPicocli(Picocli picocli) {
        this.picocli = picocli;
    }

    protected String getDefaultProfile() {
        return "prod";
    }

    public boolean isServing() {
        return false;
    }

    public boolean shouldStart() {
        return false;
    }
}

