/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.CredentialHelper;

public class UpdateTotp
implements RequiredActionProvider,
RequiredActionFactory,
CredentialRegistrator {
    private static final Logger log = Logger.getLogger(KeycloakModelUtils.class);
    public static final String ADD_RECOVERY_CODES = "add-recovery-codes";
    List<ProviderConfigProperty> ADD_RECOVERY_CODES_CONFIG_PROPERTIES = UpdateTotp.addRecoveryCodesConfig();

    static List<ProviderConfigProperty> addRecoveryCodesConfig() {
        return ProviderConfigurationBuilder.create().property().name(ADD_RECOVERY_CODES).label("Add Recovery Codes").helpText("If this option is enabled, the user will be required to configure recovery codes following the OTP configuration.\nIf the user already has recovery codes configured, Keycloak will not ask for setting them up.\nAs a prerequisite, enable the recovery codes required action and enable recovery codes in your authentication flow.").type("boolean").defaultValue((Object)false).add().build();
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().setAttribute("mode", context.getUriInfo().getQueryParameters().getFirst((Object)"mode")).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        Stream otpCredentials;
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_CREDENTIAL);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String challengeResponse = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        String mode = (String)formData.getFirst((Object)"mode");
        String userLabel = (String)formData.getFirst((Object)"userLabel");
        OTPPolicy policy = context.getRealm().getOTPPolicy();
        OTPCredentialModel credentialModel = OTPCredentialModel.createFromPolicy((RealmModel)context.getRealm(), (String)totpSecret, (String)userLabel);
        event.detail("credential_type", credentialModel.getType());
        EventBuilder deprecatedEvent = event.clone().event(EventType.UPDATE_TOTP);
        if (Validation.isBlank(challengeResponse)) {
            Response challenge = context.form().setAttribute("mode", (Object)mode).addError(new FormMessage("totp", "missingTotpMessage")).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
            context.challenge(challenge);
            return;
        }
        if (!this.validateOTPCredential(context, challengeResponse, credentialModel, policy)) {
            Response challenge = context.form().setAttribute("mode", (Object)mode).addError(new FormMessage("totp", "invalidTotpMessage")).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
            context.challenge(challenge);
            return;
        }
        OTPCredentialProvider otpCredentialProvider = (OTPCredentialProvider)context.getSession().getProvider(CredentialProvider.class, "keycloak-otp");
        Stream stream = otpCredentials = otpCredentialProvider.isConfiguredFor(context.getRealm(), context.getUser()) ? context.getUser().credentialManager().getStoredCredentialsByTypeStream("otp") : Stream.empty();
        if (otpCredentials.count() >= 1L && Validation.isBlank(userLabel)) {
            Response challenge = context.form().setAttribute("mode", (Object)mode).addError(new FormMessage("userLabel", "missingTotpDeviceNameMessage")).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
            context.challenge(challenge);
            return;
        }
        if ("on".equals(formData.getFirst((Object)"logout-sessions"))) {
            AuthenticatorUtil.logoutOtherSessions(context);
        }
        try {
            if (!CredentialHelper.createOTPCredential((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (UserModel)context.getUser(), (String)challengeResponse, (OTPCredentialModel)credentialModel)) {
                Response challenge = context.form().setAttribute("mode", (Object)mode).addError(new FormMessage("totp", "invalidTotpMessage")).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
                context.challenge(challenge);
                return;
            }
        }
        catch (ModelDuplicateException e) {
            String field = switch (e.getDuplicateFieldName()) {
                case "userLabel" -> "userLabel";
                default -> null;
            };
            Response challenge = context.form().setAttribute("mode", (Object)mode).addError(new FormMessage(field, e.getMessage())).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
            context.challenge(challenge);
            return;
        }
        if (context.getConfig() != null && Boolean.parseBoolean(context.getConfig().getConfigValue(ADD_RECOVERY_CODES, "false"))) {
            if (!this.isRecoveryCodesEnabledInAuthenticationFlow(context.getRealm(), context.getSession())) {
                log.info((Object)"OTP configured to set up recovery codes, but recovery codes are not enabled in the authentication flows. Skipping the setup of recovery codes.");
            } else if (!context.getRealm().getRequiredActionProviderByAlias(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES.name()).isEnabled()) {
                log.info((Object)"OTP configured to set up recovery codes, but recovery codes required action is not enabled. Skipping the setup of recovery codes.");
            } else if (context.getUser().getRequiredActionsStream().noneMatch(s -> s.equals(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES.name())) && !context.getUser().credentialManager().isConfiguredFor("recovery-authn-codes")) {
                context.getUser().addRequiredAction(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES);
            }
        }
        context.getAuthenticationSession().removeAuthNote("TOTP_SECRET_KEY");
        context.success();
        deprecatedEvent.success();
    }

    private boolean isRecoveryCodesEnabledInAuthenticationFlow(RealmModel realm, KeycloakSession session) {
        return realm.getAuthenticationFlowsStream().filter(s -> !this.isFlowEffectivelyDisabled(realm, (AuthenticationFlowModel)s)).flatMap(flow -> realm.getAuthenticationExecutionsStream(flow.getId()).filter(exe -> Objects.nonNull(exe.getAuthenticator()) && exe.getRequirement() != AuthenticationExecutionModel.Requirement.DISABLED).map(exe -> (AuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, exe.getAuthenticator())).filter(Objects::nonNull).flatMap(authFact -> Stream.concat(Stream.of(authFact.getReferenceCategory()), authFact.getOptionalReferenceCategories(session).stream())).filter(Objects::nonNull)).anyMatch(s -> s.equals("recovery-authn-codes"));
    }

    private boolean isFlowEffectivelyDisabled(RealmModel realm, AuthenticationFlowModel flow) {
        while (!flow.isTopLevel()) {
            AuthenticationExecutionModel flowExecution = realm.getAuthenticationExecutionByFlowId(flow.getId());
            if (flowExecution == null) {
                return false;
            }
            if (AuthenticationExecutionModel.Requirement.DISABLED == flowExecution.getRequirement()) {
                return true;
            }
            if (flowExecution.getParentFlow() == null) {
                return false;
            }
            flow = realm.getAuthenticationFlowById(flowExecution.getParentFlow());
            if (flow != null) continue;
            return false;
        }
        return false;
    }

    protected boolean validateOTPCredential(RequiredActionContext context, String token, OTPCredentialModel credentialModel, OTPPolicy policy) {
        return CredentialValidation.validOTP((String)token, (OTPCredentialModel)credentialModel, (int)policy.getLookAheadWindow());
    }

    public void close() {
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ArrayList<ProviderConfigProperty> configs = new ArrayList<ProviderConfigProperty>(List.copyOf(MAX_AUTH_AGE_CONFIG_PROPERTIES));
        configs.addAll(List.copyOf(this.ADD_RECOVERY_CODES_CONFIG_PROPERTIES));
        return configs;
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Configure OTP";
    }

    public String getId() {
        return UserModel.RequiredAction.CONFIGURE_TOTP.name();
    }

    public String getCredentialType(KeycloakSession session, AuthenticationSessionModel authenticationSession) {
        return "otp";
    }

    public boolean isOneTimeAction() {
        return true;
    }
}

