/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.common.process;

import org.infinispan.api.Experimental;

@Experimental
public interface CacheEntryProcessorResult<K, T> {
    public K key();

    public T result();

    public Throwable error();

    public static <K, T> CacheEntryProcessorResult<K, T> onResult(K key, T result) {
        return new Impl<K, T>(key, result, null);
    }

    public static <K, T> CacheEntryProcessorResult<K, T> onError(K key, Throwable throwable) {
        return new Impl<K, Object>(key, null, throwable);
    }

    public static class Impl<K, T>
    implements CacheEntryProcessorResult<K, T> {
        private final K key;
        private final T result;
        private final Throwable throwable;

        public Impl(K key, T result, Throwable throwable) {
            this.key = key;
            this.result = result;
            this.throwable = throwable;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public T result() {
            return this.result;
        }

        @Override
        public Throwable error() {
            return this.throwable;
        }
    }
}

