/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.MappingNotFoundException;
import org.hibernate.boot.jaxb.JaxbLogger;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.internal.InputStreamXmlSource;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;

public class UrlXmlSource {
    public static Binding<? extends JaxbBindableMappingDescriptor> fromResource(String resourceName, ClassLoaderService classLoaderService, MappingBinder mappingBinder) {
        JaxbLogger.JAXB_LOGGER.tracef("Reading mappings from resource: %s", resourceName);
        Origin origin = new Origin(SourceType.RESOURCE, resourceName);
        URL url = classLoaderService.locateResource(resourceName);
        if (url == null) {
            throw new MappingNotFoundException(origin);
        }
        return UrlXmlSource.fromUrl(url, origin, mappingBinder);
    }

    public static Binding<? extends JaxbBindableMappingDescriptor> fromUrl(URL url, MappingBinder mappingBinder) {
        Origin origin = new Origin(SourceType.URL, url.toExternalForm());
        return UrlXmlSource.fromUrl(url, origin, mappingBinder);
    }

    public static Binding<? extends JaxbBindableMappingDescriptor> fromUrl(URL url, Origin origin, MappingBinder binder) {
        JaxbLogger.JAXB_LOGGER.tracef("Reading mapping document from URL: %s", origin.getName());
        try {
            InputStream stream = url.openStream();
            return InputStreamXmlSource.fromStream(stream, origin, true, binder);
        }
        catch (UnknownHostException e) {
            throw new MappingNotFoundException("Invalid URL", e, origin);
        }
        catch (IOException e) {
            throw new MappingException("Unable to open URL InputStream", e, origin);
        }
    }
}

