/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.hmm;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.hmm.FirstOrderHiddenMarkovModel;
import com.hankcs.hanlp.model.hmm.HMMTrainer;
import com.hankcs.hanlp.model.hmm.HiddenMarkovModel;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import com.hankcs.hanlp.tokenizer.lexical.NERecognizer;
import java.util.List;

public class HMMNERecognizer
extends HMMTrainer
implements NERecognizer {
    NERTagSet tagSet = new NERTagSet();

    public HMMNERecognizer(HiddenMarkovModel model) {
        super(model);
        this.tagSet.nerLabels.add("nr");
        this.tagSet.nerLabels.add("ns");
        this.tagSet.nerLabels.add("nt");
    }

    public HMMNERecognizer() {
        this(new FirstOrderHiddenMarkovModel());
    }

    @Override
    protected List<String[]> convertToSequence(Sentence sentence) {
        List<String[]> collector = Utility.convertSentenceToNER(sentence, this.tagSet);
        for (String[] pair : collector) {
            pair[1] = pair[2];
        }
        return collector;
    }

    @Override
    protected TagSet getTagSet() {
        return this.tagSet;
    }

    @Override
    public String[] recognize(String[] wordArray, String[] posArray) {
        int[] obsArray = new int[wordArray.length];
        for (int i = 0; i < obsArray.length; ++i) {
            obsArray[i] = this.vocabulary.idOf(wordArray[i]);
        }
        int[] tagArray = new int[obsArray.length];
        this.model.predict(obsArray, tagArray);
        String[] tags = new String[obsArray.length];
        for (int i = 0; i < tagArray.length; ++i) {
            tags[i] = this.tagSet.stringOf(tagArray[i]);
        }
        return tags;
    }

    @Override
    public NERTagSet getNERTagSet() {
        return this.tagSet;
    }
}

