/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.nut;

import com.github.kokorin.jaffree.Rational;
import com.github.kokorin.jaffree.nut.FrameCode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class MainHeader {
    public final long majorVersion;
    public final long minorVersion;
    public final int streamCount;
    public final long maxDistance;
    public final Rational[] timeBases;
    public final FrameCode[] frameCodes;
    public final long[] elisionHeaderSize;
    public final Set<Flag> flags;

    public MainHeader(long majorVersion, long minorVersion, int streamCount, long maxDistance, Rational[] timeBases, FrameCode[] frameCodes, long[] elisionHeaderSize, Set<Flag> flags) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.streamCount = streamCount;
        this.maxDistance = maxDistance;
        this.timeBases = timeBases;
        this.frameCodes = frameCodes;
        this.elisionHeaderSize = elisionHeaderSize;
        this.flags = Collections.unmodifiableSet(flags);
    }

    public String toString() {
        return "MainHeader{majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", streamCount=" + this.streamCount + ", maxDistance=" + this.maxDistance + ", timeBases=" + Arrays.toString(this.timeBases) + ", frameCodes=" + Arrays.toString(this.frameCodes) + ", elisionHeaderSize=" + Arrays.toString(this.elisionHeaderSize) + ", flags=" + this.flags + '}';
    }

    public static enum Flag {
        BROADCAST_MODE(1L);

        private final long code;

        private Flag(long code) {
            this.code = code;
        }

        public static Set<Flag> fromBitCode(long value) {
            if (value == Flag.BROADCAST_MODE.code) {
                return Collections.singleton(BROADCAST_MODE);
            }
            return Collections.emptySet();
        }

        public static long toBitCode(Set<Flag> flags) {
            long result = 0L;
            for (Flag flag : flags) {
                result += flag.code;
            }
            return result;
        }
    }
}

