/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.nut;

import com.github.kokorin.jaffree.nut.CRC32;
import com.github.kokorin.jaffree.nut.Timestamp;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class NutOutputStream
implements AutoCloseable {
    private final OutputStream output;
    private final CRC32 crc32 = new CRC32();
    private long position = 0L;

    public NutOutputStream(OutputStream output) {
        this.output = NutOutputStream.asBuffered(output);
    }

    public void writeValue(long value) throws IOException {
        int b;
        long value63bits = value & Long.MAX_VALUE;
        int i = 7;
        while (value63bits >> i != 0L) {
            i += 7;
        }
        i -= 7;
        while (i > 0) {
            b = (int)(0x80L | value63bits >> i);
            this.output.write(b);
            this.crc32.update(b);
            ++this.position;
            i -= 7;
        }
        b = (int)(value63bits & 0x7FL);
        this.output.write(b);
        this.crc32.update(b);
        ++this.position;
    }

    public void writeSignedValue(long signed) throws IOException {
        long value = signed > 0L ? signed << 1 : 1L - (signed << 1);
        this.writeValue(--value);
    }

    public void writeLong(long value) throws IOException {
        for (int i = 7; i >= 0; --i) {
            int b = (int)(value >> 8 * i & 0xFFL);
            this.output.write(b);
            this.crc32.update(b);
            ++this.position;
        }
    }

    public void writeInt(long value) throws IOException {
        for (int i = 3; i >= 0; --i) {
            int b = (int)(value >> 8 * i & 0xFFL);
            this.output.write(b);
            this.crc32.update(b);
            ++this.position;
        }
    }

    public void writeByte(int value) throws IOException {
        this.output.write(value);
        this.crc32.update(value);
        ++this.position;
    }

    public void writeVariablesString(String data) throws IOException {
        this.writeVariableBytes(data.getBytes());
    }

    public void writeCString(String data) throws IOException {
        this.writeBytes(data.getBytes());
        this.writeByte(0);
    }

    public void writeVariableBytes(byte[] data) throws IOException {
        this.writeValue(data.length);
        this.writeBytes(data);
    }

    public void writeTimestamp(int timeBaseCount, Timestamp timestamp) throws IOException {
        long value = timestamp.pts * (long)timeBaseCount + (long)timestamp.timebaseId;
        this.writeValue(value);
    }

    public void writeBytes(byte[] data) throws IOException {
        this.output.write(data);
        this.crc32.update(data);
        this.position += (long)data.length;
    }

    public void resetCrc32() {
        this.crc32.reset();
    }

    public void writeCrc32() throws IOException {
        this.writeInt(this.crc32.getValue());
    }

    public long getPosition() {
        return this.position;
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws Exception {
        this.output.close();
    }

    private static BufferedOutputStream asBuffered(OutputStream outputStream) {
        if (outputStream instanceof BufferedOutputStream) {
            return (BufferedOutputStream)outputStream;
        }
        return new BufferedOutputStream(outputStream);
    }
}

