/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.AuthinfoResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class AuthinfoRequest
extends RequestBase
implements ToCopyableBuilder<Builder, AuthinfoRequest> {
    @Nullable
    private final String authType;
    @Nullable
    private final Boolean verbose;
    public static final Endpoint<AuthinfoRequest, AuthinfoResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<AuthinfoRequest, AuthinfoResponse>(request -> "POST", request -> "/_plugins/_security/authinfo", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, AuthinfoResponse._DESERIALIZER);

    private AuthinfoRequest(Builder builder) {
        super(builder);
        this.authType = builder.authType;
        this.verbose = builder.verbose;
    }

    public static AuthinfoRequest of(Function<Builder, ObjectBuilder<AuthinfoRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String authType() {
        return this.authType;
    }

    @Nullable
    public final Boolean verbose() {
        return this.verbose;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.authType != null) {
            params.put("auth_type", this.authType);
        }
        if (this.verbose != null) {
            params.put("verbose", String.valueOf(this.verbose));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.authType);
        result = 31 * result + Objects.hashCode(this.verbose);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthinfoRequest other = (AuthinfoRequest)o;
        return Objects.equals(this.authType, other.authType) && Objects.equals(this.verbose, other.verbose);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, AuthinfoRequest> {
        @Nullable
        private String authType;
        @Nullable
        private Boolean verbose;

        public Builder() {
        }

        private Builder(AuthinfoRequest o) {
            super(o);
            this.authType = o.authType;
            this.verbose = o.verbose;
        }

        private Builder(Builder o) {
            super(o);
            this.authType = o.authType;
            this.verbose = o.verbose;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder authType(@Nullable String value) {
            this.authType = value;
            return this;
        }

        @Nonnull
        public final Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        @Override
        @Nonnull
        public AuthinfoRequest build() {
            this._checkSingleUse();
            return new AuthinfoRequest(this);
        }
    }
}

