/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole;

import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.creole.SheetBuilder;
import net.sourceforge.plantuml.klimt.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UHorizontalLine;
import net.sourceforge.plantuml.style.ISkinSimple;

public class CreoleHorizontalLine
extends AbstractAtom
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final String line;
    private final char style;
    private final ISkinSimple skinParam;
    private static final double defaultThickness = 1.0;

    public static CreoleHorizontalLine create(FontConfiguration fontConfiguration, String line, char style, ISkinSimple skinParam) {
        return new CreoleHorizontalLine(fontConfiguration, line, style, skinParam);
    }

    private CreoleHorizontalLine(FontConfiguration fontConfiguration, String line, char style, ISkinSimple skinParam) {
        this.fontConfiguration = fontConfiguration;
        this.line = line;
        this.style = style;
        this.skinParam = skinParam;
    }

    private UHorizontalLine getHorizontalLine() {
        if (this.line.length() == 0) {
            return UHorizontalLine.infinite(1.0, 0.0, 0.0, this.style);
        }
        TextBlock tb = this.getTitle();
        return UHorizontalLine.infinite(1.0, 0.0, 0.0, tb, this.style);
    }

    private TextBlock getTitle() {
        if (this.line.length() == 0) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        SheetBuilder parser = this.skinParam.sheet(this.fontConfiguration, HorizontalAlignment.LEFT, CreoleMode.FULL);
        Sheet sheet = parser.createSheet(Display.getWithNewlines(this.skinParam.getPragma(), this.line));
        SheetBlock1 tb = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        return tb;
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D dim = this.calculateDimension(ug.getStringBounder());
        ug = ug.apply(UTranslate.dy(dim.getHeight() / 2.0));
        ug.draw(this.getHorizontalLine());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (this.line.length() == 0) {
            return new XDimension2D(10.0, 10.0);
        }
        TextBlock tb = this.getTitle();
        return tb.calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }
}

