/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.run.ui.grid.GridModelUpdater;
import com.intellij.database.run.ui.grid.GridModelUpdaterUtil;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridStorageAndModelUpdater
implements GridModelUpdater {
    private final GridListModelBase<GridRow, GridColumn> myModel;
    private final GridMutationModel myMutationModel;
    private final MutationsStorage myStorage;

    public GridStorageAndModelUpdater(@NotNull GridListModelBase<GridRow, GridColumn> model, @NotNull GridMutationModel mutationModel, @Nullable MutationsStorage storage) {
        if (model == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(0);
        }
        if (mutationModel == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myMutationModel = mutationModel;
        this.myStorage = storage;
    }

    @Override
    public void removeRows(int firstRowIndex, int rowCount) {
        ModelIndexSet<GridRow> rows = ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstRowIndex, rowCount));
        if (this.myStorage != null) {
            for (ModelIndex rowIdx : rows.asIterable()) {
                this.myStorage.clearRow(rowIdx);
            }
        }
        if (firstRowIndex < this.myModel.getRowCount()) {
            this.myModel.removeRows(firstRowIndex, Math.min(rowCount, this.myModel.getRowCount() - firstRowIndex));
        }
        this.myMutationModel.notifyRowsRemoved(rows);
    }

    @Override
    public void setColumns(@NotNull List<? extends GridColumn> columns) {
        if (columns == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(2);
        }
        int oldColumnCount = this.myMutationModel.getColumnCount();
        this.myModel.clearColumns();
        if (this.myStorage != null) {
            this.myStorage.clearColumns();
        }
        this.myMutationModel.notifyColumnsRemoved(ModelIndexSet.forColumns(this.myMutationModel, GridStorageAndModelUpdater.range(0, oldColumnCount)));
        this.myModel.setColumns(columns);
        this.myMutationModel.notifyColumnsAdded(ModelIndexSet.forColumns(this.myMutationModel, GridStorageAndModelUpdater.range(0, this.myModel.getColumnCount())));
    }

    @Override
    public void setRows(int firstRowIndex, @NotNull List<? extends GridRow> rows, @NotNull GridRequestSource source) {
        if (rows == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(3);
        }
        if (source == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(4);
        }
        int firstChangedRowIndex = -1;
        int rowsUpdated = 0;
        for (int i = firstRowIndex; i < this.myMutationModel.getRowCount() && rowsUpdated < rows.size(); ++i, ++rowsUpdated) {
            ModelIndex<GridRow> rowIdx = ModelIndex.forRow(this.myModel, i);
            Object oldRow = this.myMutationModel.getRow((ModelIndex)rowIdx);
            GridRow newRow = rows.get(rowsUpdated);
            boolean areRowsEqual = GridStorageAndModelUpdater.rowsEqual((GridRow)Objects.requireNonNull(oldRow), newRow);
            if (this.myStorage != null && this.myStorage.isInsertedRow(rowIdx)) {
                this.myModel.addRow(newRow);
            } else {
                this.myModel.set(i, newRow);
            }
            if (areRowsEqual) {
                if (firstChangedRowIndex != -1) {
                    ModelIndexSet<GridRow> updatedRows = ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstChangedRowIndex, i - firstChangedRowIndex));
                    ModelIndexSet<GridColumn> updatedColumns = ModelIndexSet.forColumns(this.myMutationModel, GridStorageAndModelUpdater.range(0, this.myMutationModel.getColumnCount()));
                    this.myMutationModel.notifyCellsUpdated(updatedRows, updatedColumns, source.place);
                }
                firstChangedRowIndex = -1;
            } else if (firstChangedRowIndex == -1) {
                firstChangedRowIndex = i;
            }
            if (this.myStorage == null) continue;
            this.myStorage.clearRow(rowIdx);
        }
        if (firstChangedRowIndex != -1) {
            ModelIndexSet<GridRow> updatedRows = ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstChangedRowIndex, firstRowIndex + rowsUpdated - firstChangedRowIndex));
            ModelIndexSet<GridColumn> updatedColumns = ModelIndexSet.forColumns(this.myMutationModel, GridStorageAndModelUpdater.range(0, this.myMutationModel.getColumnCount()));
            this.myMutationModel.notifyCellsUpdated(updatedRows, updatedColumns, null);
        }
        int firstRow = this.myMutationModel.getRowCount();
        List newRows = ContainerUtil.subList(rows, (int)rowsUpdated);
        this.myModel.addRows(newRows);
        this.myMutationModel.notifyRowsAdded(ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstRow, newRows.size())));
    }

    @Override
    public void addRows(List<? extends GridRow> rows) {
        int firstRow = this.myMutationModel.getRowCount();
        this.myModel.addRows(rows);
        this.myMutationModel.notifyRowsAdded(ModelIndexSet.forRows(this.myMutationModel, GridStorageAndModelUpdater.range(firstRow, rows.size())));
    }

    @Override
    public void afterLastRowAdded() {
        this.myModel.setUpdatingNow(false);
        this.myMutationModel.afterLastRowAdded();
    }

    private static int[] range(int first, int length) {
        return GridModelUpdaterUtil.getColumnsIndicesRange(first, length);
    }

    private static boolean rowsEqual(@NotNull GridRow row1, @NotNull GridRow row2) {
        if (row1 == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(5);
        }
        if (row2 == null) {
            GridStorageAndModelUpdater.$$$reportNull$$$0(6);
        }
        if (row1.getSize() != row2.getSize()) {
            return false;
        }
        for (int i = 0; i < row1.getSize(); ++i) {
            if (Objects.equals(row1.getValue(i), row2.getValue(i))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutationModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/GridStorageAndModelUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setColumns";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setRows";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "rowsEqual";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

