/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TipsOfTheDayUsagesCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ui.tips", 13);
    public static final EventId NEXT_TIP = GROUP.registerEvent("next.tip");
    public static final EventId PREVIOUS_TIP = GROUP.registerEvent("previous.tip");
    private static final EventId1<DialogType> DIALOG_SHOWN = GROUP.registerEvent("dialog.shown", (EventField)EventFields.Enum((String)"type", DialogType.class));
    private static final EventId1<SkipReason> DIALOG_SKIPPED = GROUP.registerEvent("dialog.skipped", (EventField)EventFields.Enum((String)"reason", SkipReason.class));
    private static final EventId2<Boolean, Boolean> DIALOG_CLOSED = GROUP.registerEvent("dialog.closed", (EventField)EventFields.Boolean((String)"keep_showing_before"), (EventField)EventFields.Boolean((String)"keep_showing_after"));
    private static final StringEventField ALGORITHM_FIELD = EventFields.String((String)"algorithm", List.of("shuffle", "usage_and_applicability", "unknown"));
    private static final EventId3<String, String, String> TIP_SHOWN = GROUP.registerEvent("tip.shown", (EventField)EventFields.StringValidatedByCustomRule((String)"tip_id", TipInfoValidationRule.class), (EventField)ALGORITHM_FIELD, (EventField)EventFields.Version);
    private static final EventId2<String, Long> TIP_PERFORMED = GROUP.registerEvent("tip.performed", (EventField)EventFields.StringValidatedByCustomRule((String)"tip_id", TipInfoValidationRule.class), (EventField)EventFields.Long((String)"time_passed"));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void triggerTipShown(@NotNull TipAndTrickBean tip, @NotNull String algorithm, @Nullable String version) {
        if (tip == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(0);
        }
        if (algorithm == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(1);
        }
        TIP_SHOWN.log((Object)tip.getId(), (Object)algorithm, (Object)version);
    }

    public static void triggerDialogShown(@NotNull DialogType type) {
        if (type == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(2);
        }
        DIALOG_SHOWN.log((Object)type);
    }

    public static void triggerDialogSkipped(@NotNull SkipReason reason) {
        if (reason == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(3);
        }
        DIALOG_SKIPPED.log((Object)reason);
    }

    public static void triggerDialogClosed(boolean showOnStartupBefore) {
        DIALOG_CLOSED.log((Object)showOnStartupBefore, (Object)GeneralSettings.getInstance().isShowTipsOnStartup());
    }

    public static void triggerTipUsed(@NotNull String tipId, long timePassed) {
        if (tipId == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(4);
        }
        TIP_PERFORMED.log((Object)tipId, (Object)timePassed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tip";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "algorithm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tipId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/TipsOfTheDayUsagesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerTipShown";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerDialogShown";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerDialogSkipped";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerTipUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum DialogType {
        automatically,
        manually;

    }

    public static enum SkipReason {
        dialog,
        suggestions;

    }

    public static class TipInfoValidationRule
    extends CustomValidationRule {
        public static final String RULE_ID = "tip_info";

        @NotNull
        public String getRuleId() {
            return RULE_ID;
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            TipAndTrickBean tip;
            PluginInfo info;
            if (data == null) {
                TipInfoValidationRule.$$$reportNull$$$0(0);
            }
            if (context == null) {
                TipInfoValidationRule.$$$reportNull$$$0(1);
            }
            if ((info = (PluginInfo)context.getPayload(PLUGIN_INFO)) != null) {
                ValidationResultType validationResultType = info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    TipInfoValidationRule.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            Object tipId = context.eventData.get("tip_id");
            if (tipId instanceof String && (tip = TipAndTrickBean.findById((String)((String)tipId))) != null) {
                PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)tip.getPluginDescriptor());
                context.setPayload(PLUGIN_INFO, (Object)pluginInfo);
                ValidationResultType validationResultType = pluginInfo.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    TipInfoValidationRule.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                TipInfoValidationRule.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/TipsOfTheDayUsagesCollector$TipInfoValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/TipsOfTheDayUsagesCollector$TipInfoValidationRule";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

