/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

public class OptionParser {
    private final String optionSpec;
    private char optionChar = '\u0000';
    private String optionArg = null;
    private int argIndex = 0;
    private int currentOptionIndex = 0;
    private final String[] args;
    private static final char OPTION_CHAR = '-';

    public OptionParser(String string, String[] stringArray) {
        this.optionSpec = string;
        this.args = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.args, 0, stringArray.length);
    }

    public char getOptionChar() {
        return this.optionChar;
    }

    public String getOptionCharString() {
        return new String(new char[]{this.optionChar});
    }

    public String getOptionArg() {
        return this.optionArg;
    }

    public boolean moveToNextOption() throws InvalidOptionException, MissingArgumentException {
        if (this.currentOptionIndex > 0 && this.currentOptionIndex == this.args[this.argIndex].length()) {
            this.currentOptionIndex = 0;
            ++this.argIndex;
        }
        if (this.currentOptionIndex == 0) {
            if (this.argIndex >= this.args.length) {
                return false;
            }
            String string = this.args[this.argIndex];
            if (string.length() < 2 || string.charAt(0) != '-') {
                return false;
            }
            if (string.length() == 2 && string.charAt(1) == '-') {
                ++this.argIndex;
                return false;
            }
            this.currentOptionIndex = 1;
        }
        this.optionChar = this.args[this.argIndex].charAt(this.currentOptionIndex++);
        this.optionArg = null;
        int n = this.optionSpec.indexOf(this.optionChar);
        if (n < 0 || this.optionChar == ':' && n > 0) {
            throw new InvalidOptionException();
        }
        if (n + 1 < this.optionSpec.length() && this.optionSpec.charAt(n + 1) == ':') {
            if (this.currentOptionIndex < this.args[this.argIndex].length()) {
                this.optionArg = this.args[this.argIndex].substring(this.currentOptionIndex);
                this.currentOptionIndex = 0;
                ++this.argIndex;
            } else if (this.argIndex + 1 < this.args.length) {
                this.optionArg = this.args[++this.argIndex];
                ++this.argIndex;
                this.currentOptionIndex = 0;
            } else {
                throw new MissingArgumentException();
            }
        }
        return true;
    }

    public String[] getRemainingArgs() {
        String[] stringArray = new String[this.args.length - this.argIndex];
        System.arraycopy(this.args, this.argIndex, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        stringArray = stringArray2;
        OptionParser optionParser = new OptionParser(string, stringArray);
        try {
            while (optionParser.moveToNextOption()) {
                System.err.print("option " + optionParser.getOptionChar());
                String string2 = optionParser.getOptionArg();
                if (string2 == null) {
                    System.err.println(" (no argument)");
                    continue;
                }
                System.err.println(" arg=" + string2);
            }
            stringArray = optionParser.getRemainingArgs();
            int n = 0;
            while (n < stringArray.length) {
                System.err.println("arg=" + stringArray[n]);
                ++n;
            }
        }
        catch (MissingArgumentException missingArgumentException) {
            System.err.println("missing argument for option " + optionParser.getOptionChar());
        }
        catch (InvalidOptionException invalidOptionException) {
            System.err.println("invalid option " + optionParser.getOptionChar());
        }
    }

    public static class InvalidOptionException
    extends Exception {
    }

    public static class MissingArgumentException
    extends Exception {
    }
}

