/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.PropertyValue;
import org.apache.sis.internal.geoapi.filter.Name;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.opengis.util.ScopedName;

final class AssociationValue<V>
extends LeafExpression<AbstractFeature, V>
implements ValueReference<AbstractFeature, V>,
Optimization.OnExpression<AbstractFeature, V> {
    private final String[] path;
    private final PropertyValue<V> accessor;

    AssociationValue(List<String> list, PropertyValue<V> propertyValue) {
        this.path = list.toArray(new String[list.size()]);
        this.accessor = propertyValue;
    }

    private AssociationValue(String[] stringArray, PropertyValue<V> propertyValue) {
        this.path = stringArray;
        this.accessor = propertyValue;
    }

    @Override
    public final ScopedName getFunctionName() {
        return Name.VALUE_REFERENCE;
    }

    @Override
    protected final Collection<?> getChildren() {
        return Collections.singleton(this.getXPath());
    }

    @Override
    public final String getXPath() {
        StringJoiner stringJoiner = new StringJoiner("/", this.accessor.isVirtual ? "/*/" : "", "");
        for (String string : this.path) {
            stringJoiner.add(string);
        }
        return stringJoiner.add(this.accessor.name).toString();
    }

    @Override
    public V apply(AbstractFeature abstractFeature) {
        block3: {
            if (abstractFeature != null) {
                for (String string : this.path) {
                    Object object = abstractFeature.getPropertyValue(string);
                    if (object instanceof AbstractFeature) {
                        abstractFeature = (AbstractFeature)object;
                        continue;
                    }
                    break block3;
                }
                return this.accessor.apply(abstractFeature);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression<AbstractFeature, V> optimize(Optimization optimization) {
        block11: {
            DefaultFeatureType defaultFeatureType = optimization.getFeatureType();
            if (defaultFeatureType != null) {
                try {
                    Expression expression;
                    DefaultFeatureType defaultFeatureType2 = defaultFeatureType;
                    String[] stringArray = this.path;
                    for (int i = 0; i < this.path.length; ++i) {
                        AbstractIdentifiedType abstractIdentifiedType = defaultFeatureType2.getProperty(this.path[i]);
                        Optional<String> optional = Features.getLinkTarget(abstractIdentifiedType);
                        if (optional.isPresent()) {
                            if (stringArray == this.path) {
                                stringArray = (String[])stringArray.clone();
                            }
                            stringArray[i] = optional.get();
                            abstractIdentifiedType = defaultFeatureType2.getProperty(stringArray[i]);
                        }
                        if (abstractIdentifiedType instanceof DefaultAssociationRole) {
                            defaultFeatureType2 = ((DefaultAssociationRole)abstractIdentifiedType).getValueType();
                            continue;
                        }
                        break block11;
                    }
                    optimization.setFeatureType(defaultFeatureType2);
                    try {
                        expression = this.accessor.optimize(optimization);
                    }
                    finally {
                        optimization.setFeatureType(defaultFeatureType);
                    }
                    if (expression != this.accessor || stringArray != this.path) {
                        return new AssociationValue<V>(stringArray, expression);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.warning(illegalArgumentException, true);
                }
            }
        }
        return this;
    }

    @Override
    public final <N> Expression<AbstractFeature, N> toValueType(Class<N> clazz) {
        Expression expression = this.accessor.toValueType((Class)clazz);
        if (expression == this.accessor) {
            return this;
        }
        return new AssociationValue<V>(this.path, expression);
    }

    @Override
    public PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
        for (String string : this.path) {
            AbstractIdentifiedType abstractIdentifiedType;
            try {
                abstractIdentifiedType = defaultFeatureType.getProperty(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.accessor.isVirtual) {
                    return this.accessor.expectedType(featureTypeBuilder);
                }
                throw illegalArgumentException;
            }
            if (!(abstractIdentifiedType instanceof DefaultAssociationRole)) {
                return null;
            }
            defaultFeatureType = ((DefaultAssociationRole)abstractIdentifiedType).getValueType();
        }
        return this.accessor.expectedType(defaultFeatureType, featureTypeBuilder);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.path) + this.accessor.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AssociationValue) {
            AssociationValue associationValue = (AssociationValue)object;
            return Arrays.equals(this.path, associationValue.path) && this.accessor.equals(associationValue.accessor);
        }
        return false;
    }
}

