/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.atoms;

import com.drew.lang.SequentialReader;
import com.drew.metadata.mov.QuickTimeDirectory;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.atoms.FullAtom;
import java.io.IOException;

public class TrackHeaderAtom
extends FullAtom {
    int[] matrix = new int[9];
    long width;
    long height;

    public TrackHeaderAtom(SequentialReader reader, Atom atom) throws IOException {
        super(reader, atom);
        if (this.version == 1) {
            reader.skip(48L);
        } else {
            reader.skip(36L);
        }
        for (int i = 0; i < 9; ++i) {
            this.matrix[i] = reader.getInt32();
        }
        this.width = reader.getInt32();
        this.height = reader.getInt32();
    }

    public void addMetadata(QuickTimeDirectory directory) {
        if (this.width != 0L && this.height != 0L && directory.getDoubleObject(512) == null) {
            double x = this.matrix[1] + this.matrix[4];
            double y = this.matrix[0] + this.matrix[3];
            double theta = Math.atan2(y, x);
            double degree = Math.toDegrees(theta) - 45.0;
            directory.setDouble(270, degree);
        }
    }
}

