/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.net.DomainNameResolver;
import org.apache.hadoop.net.DomainNameResolverFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNNFailoverProxyProvider<T>
implements FailoverProxyProvider<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractNNFailoverProxyProvider.class);
    protected Configuration conf;
    protected Class<T> xface;
    protected HAProxyFactory<T> factory;
    protected UserGroupInformation ugi;
    protected AtomicBoolean fallbackToSimpleAuth;

    protected AbstractNNFailoverProxyProvider() {
    }

    protected AbstractNNFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory) {
        this.conf = new Configuration(conf);
        this.xface = xface;
        this.factory = factory;
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int maxRetries = this.conf.getInt("dfs.client.failover.connection.retries", 0);
        this.conf.setInt("ipc.client.connect.max.retries", maxRetries);
        int maxRetriesOnSocketTimeouts = this.conf.getInt("dfs.client.failover.connection.retries.on.timeouts", 0);
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", maxRetriesOnSocketTimeouts);
    }

    public abstract boolean useLogicalURI();

    public synchronized void setFallbackToSimpleAuth(AtomicBoolean fallbackToSimpleAuth) {
        this.fallbackToSimpleAuth = fallbackToSimpleAuth;
    }

    public synchronized AtomicBoolean getFallbackToSimpleAuth() {
        return this.fallbackToSimpleAuth;
    }

    @Override
    public Class<T> getInterface() {
        return this.xface;
    }

    protected NNProxyInfo<T> createProxyIfNeeded(NNProxyInfo<T> pi) {
        if (pi.proxy == null) {
            assert (pi.getAddress() != null) : "Proxy address is null";
            try {
                pi.proxy = this.factory.createProxy(this.conf, pi.getAddress(), this.xface, this.ugi, false, this.getFallbackToSimpleAuth());
            }
            catch (IOException ioe) {
                LOG.error("{} Failed to create RPC proxy to NameNode at {}", new Object[]{this.getClass().getSimpleName(), ((NNProxyInfo)pi).address, ioe});
                throw new RuntimeException(ioe);
            }
        }
        return pi;
    }

    protected List<NNProxyInfo<T>> getProxyAddresses(URI uri, String addressKey) {
        ArrayList<NNProxyInfo<T>> proxies = new ArrayList<NNProxyInfo<T>>();
        Map<String, Map<String, InetSocketAddress>> map = DFSUtilClient.getAddresses(this.conf, null, addressKey);
        Map<String, InetSocketAddress> addressesInNN = map.get(uri.getHost());
        if (addressesInNN == null || addressesInNN.size() == 0) {
            throw new RuntimeException("Could not find any configured addresses for URI " + uri);
        }
        Collection<InetSocketAddress> addressesOfNns = addressesInNN.values();
        try {
            addressesOfNns = this.getResolvedHostsIfNecessary(addressesOfNns, uri);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (InetSocketAddress address : addressesOfNns) {
            proxies.add(new NNProxyInfo(address));
        }
        boolean randomized = AbstractNNFailoverProxyProvider.getRandomOrder(this.conf, uri);
        if (randomized) {
            Collections.shuffle(proxies);
        }
        HAUtilClient.cloneDelegationTokenForLogicalUri(this.ugi, uri, addressesOfNns);
        return proxies;
    }

    Collection<InetSocketAddress> getResolvedHostsIfNecessary(Collection<InetSocketAddress> addressesOfNns, URI nameNodeUri) throws IOException {
        String host = nameNodeUri.getHost();
        String configKeyWithHost = "dfs.client.failover.resolve-needed." + host;
        boolean resolveNeeded = this.conf.getBoolean(configKeyWithHost, false);
        if (!resolveNeeded) {
            return addressesOfNns;
        }
        String useFQDNKeyWithHost = "dfs.client.failover.resolver.useFQDN." + host;
        boolean requireFQDN = this.conf.getBoolean(useFQDNKeyWithHost, true);
        ArrayList<InetSocketAddress> addressOfResolvedNns = new ArrayList<InetSocketAddress>();
        DomainNameResolver dnr = DomainNameResolverFactory.newInstance(this.conf, nameNodeUri, "dfs.client.failover.resolver.impl");
        LOG.debug("Namenode domain name will be resolved with {}", (Object)dnr.getClass().getName());
        for (InetSocketAddress address : addressesOfNns) {
            String[] resolvedHostNames = dnr.getAllResolvedHostnameByDomainName(address.getHostName(), requireFQDN);
            int port = address.getPort();
            for (String hostname : resolvedHostNames) {
                InetSocketAddress resolvedAddress = new InetSocketAddress(hostname, port);
                addressOfResolvedNns.add(resolvedAddress);
            }
        }
        return addressOfResolvedNns;
    }

    public static boolean getRandomOrder(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        String configKeyWithHost = "dfs.client.failover.random.order." + host;
        if (conf.get(configKeyWithHost) != null) {
            return conf.getBoolean(configKeyWithHost, true);
        }
        return conf.getBoolean("dfs.client.failover.random.order", true);
    }

    public static class NNProxyInfo<T>
    extends FailoverProxyProvider.ProxyInfo<T> {
        private InetSocketAddress address;
        private HAServiceProtocol.HAServiceState cachedState;

        public NNProxyInfo(InetSocketAddress address) {
            super(null, address.toString());
            this.address = address;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public void setCachedState(HAServiceProtocol.HAServiceState state) {
            this.cachedState = state;
        }

        public HAServiceProtocol.HAServiceState getCachedState() {
            return this.cachedState;
        }
    }
}

