/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import jakarta.servlet.ServletConnection;
import jakarta.servlet.http.WebConnection;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolException;
import org.apache.coyote.Request;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http2.AbstractNonZeroStream;
import org.apache.coyote.http2.AbstractStream;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.ConnectionSettingsLocal;
import org.apache.coyote.http2.ConnectionSettingsRemote;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.HeaderSink;
import org.apache.coyote.http2.HpackDecoder;
import org.apache.coyote.http2.HpackEncoder;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Http2Parser;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.coyote.http2.SendfileData;
import org.apache.coyote.http2.Setting;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.coyote.http2.StreamProcessor;
import org.apache.coyote.http2.StreamRunnable;
import org.apache.coyote.http2.StreamStateMachine;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.Priority;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

class Http2UpgradeHandler
extends AbstractStream
implements InternalHttpUpgradeHandler,
Http2Parser.Input,
Http2Parser.Output {
    protected static final Log log = LogFactory.getLog(Http2UpgradeHandler.class);
    protected static final StringManager sm = StringManager.getManager(Http2UpgradeHandler.class);
    private static final Integer STREAM_ID_ZERO = 0;
    protected static final int FLAG_END_OF_STREAM = 1;
    protected static final int FLAG_END_OF_HEADERS = 4;
    protected static final byte[] PING = new byte[]{0, 0, 8, 6, 0, 0, 0, 0, 0};
    protected static final byte[] PING_ACK = new byte[]{0, 0, 8, 6, 1, 0, 0, 0, 0};
    protected static final byte[] SETTINGS_ACK = new byte[]{0, 0, 0, 4, 1, 0, 0, 0, 0};
    protected static final byte[] GOAWAY = new byte[]{7, 0, 0, 0, 0, 0};
    private static final String HTTP2_SETTINGS_HEADER = "HTTP2-Settings";
    protected static final HeaderSink HEADER_SINK = new HeaderSink();
    protected static final UserDataHelper userDataHelper = new UserDataHelper(log);
    protected final String connectionId;
    protected final Http2Protocol protocol;
    private final Adapter adapter;
    protected final SocketWrapperBase<?> socketWrapper;
    private volatile SSLSupport sslSupport;
    private volatile Http2Parser parser;
    private final AtomicReference<ConnectionState> connectionState = new AtomicReference<ConnectionState>(ConnectionState.NEW);
    private volatile long pausedNanoTime = Long.MAX_VALUE;
    private final ConnectionSettingsRemote remoteSettings;
    protected final ConnectionSettingsLocal localSettings;
    private HpackDecoder hpackDecoder;
    private HpackEncoder hpackEncoder;
    private final ConcurrentNavigableMap<Integer, AbstractNonZeroStream> streams = new ConcurrentSkipListMap<Integer, AbstractNonZeroStream>();
    protected final AtomicInteger activeRemoteStreamCount = new AtomicInteger(0);
    private volatile int maxProcessedStreamId;
    private final AtomicInteger nextLocalStreamId = new AtomicInteger(2);
    private final PingManager pingManager = this.getPingManager();
    private volatile int newStreamsSinceLastPrune = 0;
    private final Set<Stream> backLogStreams = new HashSet<Stream>();
    private long backLogSize = 0L;
    private volatile long connectionTimeout = -1L;
    private AtomicInteger streamConcurrency = null;
    private Queue<StreamRunnable> queuedRunnable = null;
    private final AtomicLong overheadCount;
    private volatile int lastNonFinalDataPayload;
    private volatile int lastWindowUpdate;

    Http2UpgradeHandler(Http2Protocol http2Protocol, Adapter adapter, Request request, SocketWrapperBase<?> socketWrapperBase) {
        super(STREAM_ID_ZERO);
        this.protocol = http2Protocol;
        this.adapter = adapter;
        this.socketWrapper = socketWrapperBase;
        this.overheadCount = new AtomicLong(-10L * (long)http2Protocol.getOverheadCountFactor());
        this.lastNonFinalDataPayload = http2Protocol.getOverheadDataThreshold() * 2;
        this.lastWindowUpdate = http2Protocol.getOverheadWindowUpdateThreshold() * 2;
        this.connectionId = this.getServletConnection().getConnectionId();
        this.remoteSettings = new ConnectionSettingsRemote(this.connectionId);
        this.localSettings = new ConnectionSettingsLocal(this.connectionId);
        this.localSettings.set(Setting.MAX_CONCURRENT_STREAMS, http2Protocol.getMaxConcurrentStreams(), true);
        this.localSettings.set(Setting.INITIAL_WINDOW_SIZE, http2Protocol.getInitialWindowSize(), true);
        this.pingManager.initiateDisabled = http2Protocol.getInitiatePingDisabled();
        if (request != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("upgradeHandler.upgrade", new Object[]{this.connectionId}));
            }
            Integer n = 1;
            Stream stream = new Stream(n, this, request);
            this.streams.put(n, stream);
            this.activeRemoteStreamCount.set(1);
            this.maxProcessedStreamId = 1;
        }
    }

    protected PingManager getPingManager() {
        return new PingManager();
    }

    public void init(WebConnection webConnection) {
        Object object;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.init", new Object[]{this.connectionId, this.connectionState.get()}));
        }
        if (!this.connectionState.compareAndSet(ConnectionState.NEW, ConnectionState.CONNECTED)) {
            return;
        }
        if ((long)this.protocol.getMaxConcurrentStreamExecution() < this.localSettings.getMaxConcurrentStreams()) {
            this.streamConcurrency = new AtomicInteger(0);
            this.queuedRunnable = new ConcurrentLinkedQueue<StreamRunnable>();
        }
        this.parser = this.getParser(this.connectionId);
        Stream stream = null;
        this.socketWrapper.setReadTimeout(this.protocol.getReadTimeout());
        this.socketWrapper.setWriteTimeout(this.protocol.getWriteTimeout());
        if (webConnection != null) {
            try {
                stream = this.getStream(1, true);
                String string = stream.getCoyoteRequest().getHeader(HTTP2_SETTINGS_HEADER);
                object = Base64.getUrlDecoder().decode(string);
                FrameType.SETTINGS.check(0, ((byte[])object).length);
                for (int i = 0; i < ((byte[])object).length % 6; ++i) {
                    int n = ByteUtil.getTwoBytes(object, i * 6);
                    long l = ByteUtil.getFourBytes(object, i * 6 + 2);
                    Setting setting = Setting.valueOf(n);
                    if (setting == Setting.UNKNOWN) {
                        log.warn((Object)sm.getString("connectionSettings.unknown", new Object[]{this.connectionId, Integer.toString(n), Long.toString(l)}));
                    }
                    this.remoteSettings.set(setting, l);
                }
            }
            catch (Http2Exception http2Exception) {
                throw new ProtocolException(sm.getString("upgradeHandler.upgrade.fail", new Object[]{this.connectionId}));
            }
        }
        this.writeSettings();
        try {
            this.parser.readConnectionPreface(webConnection, stream);
        }
        catch (Http2Exception http2Exception) {
            object = sm.getString("upgradeHandler.invalidPreface", new Object[]{this.connectionId});
            if (log.isDebugEnabled()) {
                log.debug(object, (Throwable)http2Exception);
            }
            throw new ProtocolException((String)object);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.prefaceReceived", new Object[]{this.connectionId}));
        }
        this.socketWrapper.setReadTimeout(-1L);
        this.socketWrapper.setWriteTimeout(-1L);
        this.processConnection(webConnection, stream);
    }

    protected void processConnection(WebConnection webConnection, Stream stream) {
        try {
            this.pingManager.sendPing(true);
        }
        catch (IOException iOException) {
            throw new ProtocolException(sm.getString("upgradeHandler.pingFailed", new Object[]{this.connectionId}), iOException);
        }
        if (webConnection != null) {
            this.processStreamOnContainerThread(stream);
        }
    }

    protected Http2Parser getParser(String string) {
        return new Http2Parser(string, this, this);
    }

    protected void processStreamOnContainerThread(Stream stream) {
        StreamProcessor streamProcessor = new StreamProcessor(this, stream, this.adapter, this.socketWrapper);
        streamProcessor.setSslSupport(this.sslSupport);
        this.processStreamOnContainerThread(streamProcessor, SocketEvent.OPEN_READ);
    }

    protected void decrementActiveRemoteStreamCount(Stream stream) {
        if (stream != null) {
            this.setConnectionTimeoutForStreamCount(stream.decrementAndGetActiveRemoteStreamCount());
        }
    }

    void processStreamOnContainerThread(StreamProcessor streamProcessor, SocketEvent socketEvent) {
        StreamRunnable streamRunnable = new StreamRunnable(streamProcessor, socketEvent);
        if (this.streamConcurrency == null) {
            this.socketWrapper.execute(streamRunnable);
        } else if (this.getStreamConcurrency() < this.protocol.getMaxConcurrentStreamExecution()) {
            this.increaseStreamConcurrency();
            this.socketWrapper.execute(streamRunnable);
        } else {
            this.queuedRunnable.offer(streamRunnable);
        }
    }

    @Override
    public void setSocketWrapper(SocketWrapperBase<?> socketWrapperBase) {
    }

    @Override
    public void setSslSupport(SSLSupport sSLSupport) {
        this.sslSupport = sSLSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketEvent var1_1) {
        if (Http2UpgradeHandler.log.isTraceEnabled()) {
            Http2UpgradeHandler.log.trace((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.upgradeDispatch.entry", new Object[]{this.connectionId, var1_1}));
        }
        this.init(null);
        var2_2 = AbstractEndpoint.Handler.SocketState.CLOSED;
        try {
            switch (1.$SwitchMap$org$apache$tomcat$util$net$SocketEvent[var1_1.ordinal()]) {
                case 1: {
                    this.socketWrapper.getLock().lock();
                    try {
                        if (this.socketWrapper.canWrite()) {
                            this.pingManager.sendPing(false);
                        }
                    }
                    finally {
                        this.socketWrapper.getLock().unlock();
                    }
                    try {
                        this.setConnectionTimeout(-1L);
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            try {
                                if (this.parser.readFrame()) ** GOTO lbl23
                                if (!this.isOverheadLimitExceeded()) break;
                            }
                            catch (StreamException var3_4) {
                                try {
                                    var4_8 = Http2UpgradeHandler.userDataHelper.getNextMode();
                                    if (var4_8 != null) {
                                        var5_9 = Http2UpgradeHandler.sm.getString("upgradeHandler.stream.error", new Object[]{this.connectionId, Integer.toString(var3_4.getStreamId())});
                                        switch (1.$SwitchMap$org$apache$tomcat$util$log$UserDataHelper$Mode[var4_8.ordinal()]) {
                                            case 1: {
                                                var5_9 = (String)var5_9 + Http2UpgradeHandler.sm.getString("upgradeHandler.fallToDebug");
                                            }
                                            case 2: {
                                                Http2UpgradeHandler.log.info(var5_9, (Throwable)var3_4);
                                                break;
                                            }
                                            case 3: {
                                                Http2UpgradeHandler.log.debug(var5_9, (Throwable)var3_4);
                                            }
                                        }
                                    }
                                    if ((var5_9 = this.getStream(var3_4.getStreamId(), false)) == null) {
                                        this.sendStreamReset(null, var3_4);
                                        continue;
                                    }
                                    var5_9.close(var3_4);
                                    if (!this.isOverheadLimitExceeded()) continue;
                                }
                                catch (Throwable var6_10) {
                                    if (this.isOverheadLimitExceeded()) {
                                        throw new ConnectionException(Http2UpgradeHandler.sm.getString("upgradeHandler.tooMuchOverhead", new Object[]{this.connectionId}), Http2Error.ENHANCE_YOUR_CALM);
                                    }
                                    throw var6_10;
                                }
                                throw new ConnectionException(Http2UpgradeHandler.sm.getString("upgradeHandler.tooMuchOverhead", new Object[]{this.connectionId}), Http2Error.ENHANCE_YOUR_CALM);
                            }
                            throw new ConnectionException(Http2UpgradeHandler.sm.getString("upgradeHandler.tooMuchOverhead", new Object[]{this.connectionId}), Http2Error.ENHANCE_YOUR_CALM);
lbl23:
                            // 1 sources

                            if (!this.isOverheadLimitExceeded()) ** GOTO lbl-1000
                            throw new ConnectionException(Http2UpgradeHandler.sm.getString("upgradeHandler.tooMuchOverhead", new Object[]{this.connectionId}), Http2Error.ENHANCE_YOUR_CALM);
                            break;
                        }
                        this.socketWrapper.setReadTimeout(-1L);
                        this.setConnectionTimeoutForStreamCount(this.activeRemoteStreamCount.get());
                    }
                    catch (Http2Exception var3_5) {
                        if (Http2UpgradeHandler.log.isDebugEnabled()) {
                            Http2UpgradeHandler.log.debug((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.connectionError"), (Throwable)var3_5);
                        }
                        this.closeConnection(var3_5);
                        break;
                    }
                    if (this.connectionState.get() == ConnectionState.CLOSED) break;
                    if (this.socketWrapper.hasAsyncIO()) {
                        var2_2 = AbstractEndpoint.Handler.SocketState.ASYNC_IO;
                        break;
                    }
                    var2_2 = AbstractEndpoint.Handler.SocketState.UPGRADED;
                    break;
                }
                case 2: {
                    this.processWrites();
                    if (this.socketWrapper.hasAsyncIO()) {
                        var2_2 = AbstractEndpoint.Handler.SocketState.ASYNC_IO;
                        break;
                    }
                    var2_2 = AbstractEndpoint.Handler.SocketState.UPGRADED;
                    break;
                }
                case 3: {
                    this.closeConnection(null);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.close();
                }
            }
        }
        catch (IOException var3_6) {
            if (Http2UpgradeHandler.log.isDebugEnabled()) {
                Http2UpgradeHandler.log.debug((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.ioerror", new Object[]{this.connectionId}), (Throwable)var3_6);
            }
            this.close();
        }
        catch (Throwable var3_7) {
            ExceptionUtils.handleThrowable((Throwable)var3_7);
            if (Http2UpgradeHandler.log.isDebugEnabled()) {
                Http2UpgradeHandler.log.debug((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.throwable", new Object[]{this.connectionId}), var3_7);
            }
            this.close();
        }
        if (Http2UpgradeHandler.log.isTraceEnabled()) {
            Http2UpgradeHandler.log.trace((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.upgradeDispatch.exit", new Object[]{this.connectionId, var2_2}));
        }
        return var2_2;
    }

    protected void setConnectionTimeoutForStreamCount(int n) {
        if (n == 0) {
            long l = this.protocol.getKeepAliveTimeout();
            if (l == -1L) {
                this.setConnectionTimeout(-1L);
            } else {
                this.setConnectionTimeout(System.currentTimeMillis() + l);
            }
        } else {
            this.setConnectionTimeout(-1L);
        }
    }

    private void setConnectionTimeout(long l) {
        this.connectionTimeout = l;
    }

    @Override
    public void timeoutAsync(long l) {
        long l2 = this.connectionTimeout;
        if (l == -1L || l2 > -1L && l > l2) {
            this.socketWrapper.processSocket(SocketEvent.TIMEOUT, true);
        }
    }

    ConnectionSettingsRemote getRemoteSettings() {
        return this.remoteSettings;
    }

    ConnectionSettingsLocal getLocalSettings() {
        return this.localSettings;
    }

    Http2Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void pause() {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.pause.entry", new Object[]{this.connectionId}));
        }
        if (this.connectionState.compareAndSet(ConnectionState.CONNECTED, ConnectionState.PAUSING)) {
            this.pausedNanoTime = System.nanoTime();
            try {
                this.writeGoAwayFrame(Integer.MAX_VALUE, Http2Error.NO_ERROR.getCode(), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
    }

    void checkPauseState() throws IOException {
        if (this.connectionState.get() == ConnectionState.PAUSING && this.pausedNanoTime + this.pingManager.getRoundTripTimeNano() < System.nanoTime()) {
            this.connectionState.compareAndSet(ConnectionState.PAUSING, ConnectionState.PAUSED);
            this.writeGoAwayFrame(this.maxProcessedStreamId, Http2Error.NO_ERROR.getCode(), null);
        }
    }

    private int increaseStreamConcurrency() {
        return this.streamConcurrency.incrementAndGet();
    }

    private int decreaseStreamConcurrency() {
        return this.streamConcurrency.decrementAndGet();
    }

    private int getStreamConcurrency() {
        return this.streamConcurrency.get();
    }

    void executeQueuedStream() {
        StreamRunnable streamRunnable;
        if (this.streamConcurrency == null) {
            return;
        }
        this.decreaseStreamConcurrency();
        if (this.getStreamConcurrency() < this.protocol.getMaxConcurrentStreamExecution() && (streamRunnable = this.queuedRunnable.poll()) != null) {
            this.increaseStreamConcurrency();
            this.socketWrapper.execute(streamRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendStreamReset(StreamStateMachine streamStateMachine, StreamException streamException) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.rst.debug", new Object[]{this.connectionId, Integer.toString(streamException.getStreamId()), streamException.getError(), streamException.getMessage()}));
        }
        this.increaseOverheadCount(FrameType.RST, this.getProtocol().getOverheadResetFactor());
        byte[] byArray = new byte[13];
        ByteUtil.setThreeBytes(byArray, 0, 4);
        byArray[3] = FrameType.RST.getIdByte();
        ByteUtil.set31Bits(byArray, 5, streamException.getStreamId());
        ByteUtil.setFourBytes(byArray, 9, streamException.getError().getCode());
        this.socketWrapper.getLock().lock();
        try {
            if (streamStateMachine != null) {
                boolean bl = streamStateMachine.isActive();
                streamStateMachine.sendReset();
                if (bl) {
                    this.decrementActiveRemoteStreamCount(this.getStream(streamException.getStreamId()));
                }
            }
            this.socketWrapper.write(true, byArray, 0, byArray.length);
            this.socketWrapper.flush(true);
        }
        finally {
            this.socketWrapper.getLock().unlock();
        }
    }

    void closeConnection(Http2Exception http2Exception) {
        byte[] byArray;
        long l;
        if (http2Exception == null) {
            l = Http2Error.NO_ERROR.getCode();
            byArray = null;
        } else {
            l = http2Exception.getError().getCode();
            byArray = http2Exception.getMessage().getBytes(StandardCharsets.UTF_8);
        }
        try {
            this.writeGoAwayFrame(this.maxProcessedStreamId, l, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }

    protected void writeSettings() {
        try {
            byte[] byArray = this.localSettings.getSettingsFrameForPending();
            this.socketWrapper.write(true, byArray, 0, byArray.length);
            byte[] byArray2 = this.createWindowUpdateForSettings();
            if (byArray2.length > 0) {
                this.socketWrapper.write(true, byArray2, 0, byArray2.length);
            }
            this.socketWrapper.flush(true);
        }
        catch (IOException iOException) {
            String string = sm.getString("upgradeHandler.sendPrefaceFail", new Object[]{this.connectionId});
            if (log.isDebugEnabled()) {
                log.debug((Object)string);
            }
            throw new ProtocolException(string, iOException);
        }
    }

    protected byte[] createWindowUpdateForSettings() {
        byte[] byArray;
        int n = this.protocol.getInitialWindowSize() - 65535;
        if (n > 0) {
            byArray = new byte[13];
            ByteUtil.setThreeBytes(byArray, 0, 4);
            byArray[3] = FrameType.WINDOW_UPDATE.getIdByte();
            ByteUtil.set31Bits(byArray, 9, n);
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGoAwayFrame(int n, long l, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[8];
        ByteUtil.set31Bits(byArray2, 0, n);
        ByteUtil.setFourBytes(byArray2, 4, l);
        int n2 = 8;
        if (byArray != null) {
            n2 += byArray.length;
        }
        byte[] byArray3 = new byte[3];
        ByteUtil.setThreeBytes(byArray3, 0, n2);
        Lock lock = this.socketWrapper.getLock();
        lock.lock();
        try {
            this.socketWrapper.write(true, byArray3, 0, byArray3.length);
            this.socketWrapper.write(true, GOAWAY, 0, GOAWAY.length);
            this.socketWrapper.write(true, byArray2, 0, 8);
            if (byArray != null) {
                this.socketWrapper.write(true, byArray, 0, byArray.length);
            }
            this.socketWrapper.flush(true);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHeaders(Stream stream, int n, MimeHeaders mimeHeaders, boolean bl, int n2) throws IOException {
        Lock lock = this.socketWrapper.getLock();
        lock.lock();
        try {
            this.doWriteHeaders(stream, n, mimeHeaders, bl, n2);
        }
        finally {
            lock.unlock();
        }
        stream.sentHeaders();
        if (bl) {
            this.sentEndOfStream(stream);
        }
    }

    protected HeaderFrameBuffers doWriteHeaders(Stream stream, int n, MimeHeaders mimeHeaders, boolean bl, int n2) throws IOException {
        if (log.isTraceEnabled()) {
            if (n == 0) {
                log.trace((Object)sm.getString("upgradeHandler.writeHeaders", new Object[]{this.connectionId, stream.getIdAsString(), bl}));
            } else {
                log.trace((Object)sm.getString("upgradeHandler.writePushHeaders", new Object[]{this.connectionId, stream.getIdAsString(), n, bl}));
            }
        }
        if (!stream.canWrite()) {
            return null;
        }
        HeaderFrameBuffers headerFrameBuffers = this.getHeaderFrameBuffers(n2);
        byte[] byArray = null;
        if (n > 0) {
            byArray = new byte[4];
            ByteUtil.set31Bits(byArray, 0, n);
        }
        boolean bl2 = true;
        HpackEncoder.State state = null;
        while (state != HpackEncoder.State.COMPLETE) {
            headerFrameBuffers.startFrame();
            if (bl2 && byArray != null) {
                headerFrameBuffers.getPayload().put(byArray);
            }
            state = this.getHpackEncoder().encode(mimeHeaders, headerFrameBuffers.getPayload());
            headerFrameBuffers.getPayload().flip();
            if (state == HpackEncoder.State.COMPLETE || headerFrameBuffers.getPayload().limit() > 0) {
                ByteUtil.setThreeBytes(headerFrameBuffers.getHeader(), 0, headerFrameBuffers.getPayload().limit());
                if (bl2) {
                    bl2 = false;
                    headerFrameBuffers.getHeader()[3] = byArray == null ? FrameType.HEADERS.getIdByte() : FrameType.PUSH_PROMISE.getIdByte();
                    if (bl) {
                        headerFrameBuffers.getHeader()[4] = 1;
                    }
                } else {
                    headerFrameBuffers.getHeader()[3] = FrameType.CONTINUATION.getIdByte();
                }
                if (state == HpackEncoder.State.COMPLETE) {
                    byte[] byArray2 = headerFrameBuffers.getHeader();
                    byArray2[4] = (byte)(byArray2[4] + 4);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)(headerFrameBuffers.getPayload().limit() + " bytes"));
                }
                ByteUtil.set31Bits(headerFrameBuffers.getHeader(), 5, stream.getIdAsInt());
                headerFrameBuffers.endFrame();
                continue;
            }
            if (state != HpackEncoder.State.UNDERFLOW) continue;
            headerFrameBuffers.expandPayload();
        }
        headerFrameBuffers.endHeaders();
        return headerFrameBuffers;
    }

    protected HeaderFrameBuffers getHeaderFrameBuffers(int n) {
        return new DefaultHeaderFrameBuffers(n);
    }

    protected HpackEncoder getHpackEncoder() {
        if (this.hpackEncoder == null) {
            this.hpackEncoder = new HpackEncoder();
        }
        this.hpackEncoder.setMaxTableSize(this.remoteSettings.getHeaderTableSize());
        return this.hpackEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBody(Stream stream, ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.writeBody", new Object[]{this.connectionId, stream.getIdAsString(), Integer.toString(n), bl}));
        }
        this.reduceOverheadCount(FrameType.DATA);
        boolean bl2 = stream.canWrite();
        byte[] byArray = new byte[9];
        ByteUtil.setThreeBytes(byArray, 0, n);
        byArray[3] = FrameType.DATA.getIdByte();
        if (bl) {
            byArray[4] = 1;
            this.sentEndOfStream(stream);
        }
        if (bl2) {
            ByteUtil.set31Bits(byArray, 5, stream.getIdAsInt());
            this.socketWrapper.getLock().lock();
            try {
                this.socketWrapper.write(true, byArray, 0, byArray.length);
                int n2 = byteBuffer.limit();
                byteBuffer.limit(byteBuffer.position() + n);
                this.socketWrapper.write(true, byteBuffer);
                byteBuffer.limit(n2);
                this.socketWrapper.flush(true);
            }
            catch (IOException iOException) {
                this.handleAppInitiatedIOException(iOException);
            }
            finally {
                this.socketWrapper.getLock().unlock();
            }
        }
    }

    protected void sentEndOfStream(Stream stream) {
        stream.sentEndOfStream();
        if (!stream.isActive()) {
            this.decrementActiveRemoteStreamCount(stream);
        }
    }

    protected void handleAppInitiatedIOException(IOException iOException) throws IOException {
        this.close();
        throw iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeWindowUpdate(AbstractNonZeroStream abstractNonZeroStream, int n, boolean bl) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.windowUpdateConnection", new Object[]{this.getConnectionId(), n}));
        }
        this.socketWrapper.getLock().lock();
        try {
            int n2;
            byte[] byArray = new byte[13];
            ByteUtil.setThreeBytes(byArray, 0, 4);
            byArray[3] = FrameType.WINDOW_UPDATE.getIdByte();
            ByteUtil.set31Bits(byArray, 9, n);
            this.socketWrapper.write(true, byArray, 0, byArray.length);
            boolean bl2 = true;
            if (abstractNonZeroStream instanceof Stream && ((Stream)abstractNonZeroStream).canWrite() && (n2 = ((Stream)abstractNonZeroStream).getWindowUpdateSizeToWrite(n)) > 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("upgradeHandler.windowUpdateStream", new Object[]{this.getConnectionId(), this.getIdAsString(), n2}));
                }
                ByteUtil.set31Bits(byArray, 5, abstractNonZeroStream.getIdAsInt());
                ByteUtil.set31Bits(byArray, 9, n2);
                try {
                    this.socketWrapper.write(true, byArray, 0, byArray.length);
                    this.socketWrapper.flush(true);
                    bl2 = false;
                }
                catch (IOException iOException) {
                    if (bl) {
                        this.handleAppInitiatedIOException(iOException);
                    }
                    throw iOException;
                }
            }
            if (bl2) {
                this.socketWrapper.flush(true);
            }
        }
        finally {
            this.socketWrapper.getLock().unlock();
        }
    }

    protected void processWrites() throws IOException {
        Lock lock = this.socketWrapper.getLock();
        lock.lock();
        try {
            if (this.socketWrapper.flush(false)) {
                this.socketWrapper.registerWriteInterest();
            } else {
                this.pingManager.sendPing(false);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int reserveWindowSize(Stream stream, int n, boolean bl) throws IOException {
        int n2;
        block23: {
            n2 = 0;
            stream.windowAllocationLock.lock();
            try {
                long l;
                this.windowAllocationLock.lock();
                try {
                    if (!stream.canWrite()) {
                        stream.doStreamCancel(sm.getString("upgradeHandler.stream.notWritable", new Object[]{stream.getConnectionId(), stream.getIdAsString(), stream.state.getCurrentStateName()}), Http2Error.STREAM_CLOSED);
                    }
                    l = this.getWindowSize();
                    if (stream.getConnectionAllocationMade() > 0) {
                        n2 = stream.getConnectionAllocationMade();
                        stream.setConnectionAllocationMade(0);
                    } else if (l < 1L) {
                        if (stream.getConnectionAllocationMade() == 0 && stream.getConnectionAllocationRequested() == 0) {
                            stream.setConnectionAllocationRequested(n);
                            this.backLogSize += (long)n;
                            this.backLogStreams.add(stream);
                        }
                    } else if (l < (long)n) {
                        n2 = (int)l;
                        this.decrementWindowSize(n2);
                        int n3 = n - n2;
                        stream.setConnectionAllocationRequested(n3);
                        this.backLogSize += (long)n3;
                        this.backLogStreams.add(stream);
                    } else {
                        n2 = n;
                        this.decrementWindowSize(n2);
                    }
                }
                finally {
                    this.windowAllocationLock.unlock();
                }
                if (n2 != 0) break block23;
                if (bl) {
                    try {
                        l = this.protocol.getWriteTimeout();
                        stream.waitForConnectionAllocation(l);
                        if (stream.getConnectionAllocationMade() == 0) {
                            Http2Error http2Error;
                            String string;
                            if (stream.isActive()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)sm.getString("upgradeHandler.noAllocation", new Object[]{this.connectionId, stream.getIdAsString()}));
                                }
                                this.close();
                                string = sm.getString("stream.writeTimeout");
                                http2Error = Http2Error.ENHANCE_YOUR_CALM;
                            } else {
                                string = sm.getString("upgradeHandler.clientCancel");
                                http2Error = Http2Error.STREAM_CLOSED;
                            }
                            stream.doStreamCancel(string, http2Error);
                        } else {
                            n2 = stream.getConnectionAllocationMade();
                            stream.setConnectionAllocationMade(0);
                        }
                        break block23;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(sm.getString("upgradeHandler.windowSizeReservationInterrupted", new Object[]{this.connectionId, stream.getIdAsString(), Integer.toString(n)}), interruptedException);
                    }
                }
                stream.waitForConnectionAllocationNonBlocking();
                int n4 = 0;
                return n4;
            }
            finally {
                stream.windowAllocationLock.unlock();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void incrementWindowSize(int n) throws Http2Exception {
        Set<AbstractStream> set = null;
        this.windowAllocationLock.lock();
        try {
            long l = this.getWindowSize();
            if (l < 1L && l + (long)n > 0L) {
                set = this.releaseBackLog((int)(l + (long)n));
            } else {
                super.incrementWindowSize(n);
            }
        }
        finally {
            this.windowAllocationLock.unlock();
        }
        if (set != null) {
            for (AbstractStream abstractStream : set) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("upgradeHandler.releaseBacklog", new Object[]{this.connectionId, abstractStream.getIdAsString()}));
                }
                if (this == abstractStream) continue;
                ((Stream)abstractStream).notifyConnection();
            }
        }
    }

    protected SendfileState processSendfile(SendfileData sendfileData) {
        return SendfileState.DONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<AbstractStream> releaseBackLog(int n) throws Http2Exception {
        this.windowAllocationLock.lock();
        try {
            HashSet<AbstractStream> hashSet = new HashSet<AbstractStream>();
            if (this.backLogSize < (long)n) {
                for (AbstractStream abstractStream : this.backLogStreams) {
                    if (abstractStream.getConnectionAllocationRequested() <= 0) continue;
                    abstractStream.setConnectionAllocationMade(abstractStream.getConnectionAllocationRequested());
                    abstractStream.setConnectionAllocationRequested(0);
                    hashSet.add(abstractStream);
                }
                int n2 = n - (int)this.backLogSize;
                this.backLogSize = 0L;
                super.incrementWindowSize(n2);
                this.backLogStreams.clear();
            } else {
                ConcurrentSkipListSet<Stream> concurrentSkipListSet = new ConcurrentSkipListSet<Stream>(Comparator.comparingInt(Stream::getUrgency).thenComparing(Stream::getIncremental).thenComparing(AbstractStream::getIdAsInt));
                concurrentSkipListSet.addAll(this.backLogStreams);
                long l = 0L;
                long l2 = 0L;
                int n3 = n;
                for (Stream stream : concurrentSkipListSet) {
                    if (l < (long)stream.getUrgency()) {
                        if (n3 < 1) break;
                        l2 = 0L;
                    }
                    l = stream.getUrgency();
                    if (stream.getIncremental()) {
                        l2 += (long)stream.getConnectionAllocationRequested();
                        n3 -= stream.getConnectionAllocationRequested();
                        continue;
                    }
                    if ((n3 -= stream.getConnectionAllocationRequested()) >= 1) continue;
                    break;
                }
                n3 = n;
                Iterator iterator = concurrentSkipListSet.iterator();
                while (iterator.hasNext()) {
                    Stream stream;
                    stream = (Stream)iterator.next();
                    if ((long)stream.getUrgency() < l) {
                        n3 = this.allocate(stream, n3);
                        hashSet.add(stream);
                        iterator.remove();
                        this.backLogStreams.remove(stream);
                        continue;
                    }
                    if (l2 == 0L) {
                        n3 = this.allocate(stream, n3);
                        hashSet.add(stream);
                        if (stream.getConnectionAllocationRequested() == 0) {
                            iterator.remove();
                            this.backLogStreams.remove(stream);
                        }
                        if (n3 >= 1) continue;
                        break;
                    }
                    if ((long)stream.getUrgency() != l) break;
                    int n4 = (int)((long)(stream.getConnectionAllocationRequested() * n3) / l2);
                    if (n4 == 0) {
                        n4 = 1;
                    }
                    this.allocate(stream, n4);
                    hashSet.add(stream);
                    if (stream.getConnectionAllocationRequested() != 0) continue;
                    iterator.remove();
                    this.backLogStreams.remove(stream);
                }
            }
            HashSet<AbstractStream> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this.windowAllocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocate(AbstractStream abstractStream, int n) {
        this.windowAllocationLock.lock();
        try {
            int n2;
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("upgradeHandler.allocate.debug", new Object[]{this.getConnectionId(), abstractStream.getIdAsString(), Integer.toString(n)}));
            }
            int n3 = n;
            if (abstractStream.getConnectionAllocationRequested() > 0) {
                n2 = Math.min(n, abstractStream.getConnectionAllocationRequested());
                abstractStream.setConnectionAllocationRequested(abstractStream.getConnectionAllocationRequested() - n2);
                abstractStream.setConnectionAllocationMade(abstractStream.getConnectionAllocationMade() + n2);
                n3 -= n2;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("upgradeHandler.allocate.left", new Object[]{this.getConnectionId(), abstractStream.getIdAsString(), Integer.toString(n3)}));
            }
            n2 = n3;
            return n2;
        }
        finally {
            this.windowAllocationLock.unlock();
        }
    }

    Stream getStream(int n) {
        Integer n2 = n;
        AbstractStream abstractStream = (AbstractStream)this.streams.get(n2);
        if (abstractStream instanceof Stream) {
            return (Stream)abstractStream;
        }
        return null;
    }

    private Stream getStream(int n, boolean bl) throws ConnectionException {
        Stream stream = this.getStream(n);
        if (stream == null && bl) {
            throw new ConnectionException(sm.getString("upgradeHandler.stream.closed", new Object[]{Integer.toString(n)}), Http2Error.PROTOCOL_ERROR);
        }
        return stream;
    }

    private AbstractNonZeroStream getAbstractNonZeroStream(int n) {
        Integer n2 = n;
        return (AbstractNonZeroStream)this.streams.get(n2);
    }

    private AbstractNonZeroStream getAbstractNonZeroStream(int n, boolean bl) throws ConnectionException {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n);
        if (abstractNonZeroStream == null && bl) {
            throw new ConnectionException(sm.getString("upgradeHandler.stream.closed", new Object[]{Integer.toString(n)}), Http2Error.PROTOCOL_ERROR);
        }
        return abstractNonZeroStream;
    }

    private Stream createRemoteStream(int n) throws ConnectionException {
        Integer n2 = n;
        if (n % 2 != 1) {
            throw new ConnectionException(sm.getString("upgradeHandler.stream.even", new Object[]{n2}), Http2Error.PROTOCOL_ERROR);
        }
        this.pruneClosedStreams(n);
        Stream stream = new Stream(n2, this);
        this.streams.put(n2, stream);
        return stream;
    }

    private Stream createLocalStream(Request request) {
        int n = this.nextLocalStreamId.getAndAdd(2);
        Integer n2 = n;
        Stream stream = new Stream(n2, this, request);
        this.streams.put(n2, stream);
        return stream;
    }

    private void close() {
        ConnectionState connectionState = this.connectionState.getAndSet(ConnectionState.CLOSED);
        if (connectionState == ConnectionState.CLOSED) {
            return;
        }
        for (AbstractNonZeroStream abstractNonZeroStream : this.streams.values()) {
            if (!(abstractNonZeroStream instanceof Stream)) continue;
            ((Stream)abstractNonZeroStream).receiveReset(Http2Error.CANCEL.getCode());
        }
        try {
            this.socketWrapper.close();
        }
        catch (Exception exception) {
            log.debug((Object)sm.getString("upgradeHandler.socketCloseFailed"), (Throwable)exception);
        }
    }

    private void pruneClosedStreams(int n) {
        if (this.newStreamsSinceLastPrune < 9) {
            ++this.newStreamsSinceLastPrune;
            return;
        }
        this.newStreamsSinceLastPrune = 0;
        long l = this.localSettings.getMaxConcurrentStreams();
        if ((l *= 5L) > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        int n2 = this.streams.size();
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.pruneStart", new Object[]{this.connectionId, Long.toString(l), Integer.toString(n2)}));
        }
        int n3 = n2 - (int)l;
        for (AbstractNonZeroStream abstractNonZeroStream : this.streams.values()) {
            if (n3 < 1) {
                return;
            }
            if (abstractNonZeroStream instanceof Stream && ((Stream)abstractNonZeroStream).isActive()) continue;
            this.streams.remove(abstractNonZeroStream.getIdentifier());
            --n3;
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)sm.getString("upgradeHandler.pruned", new Object[]{this.connectionId, abstractNonZeroStream.getIdAsString()}));
        }
        if (n3 > 0) {
            log.warn((Object)sm.getString("upgradeHandler.pruneIncomplete", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n3)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(Request request, Stream stream) throws IOException {
        Stream stream2;
        if (this.localSettings.getMaxConcurrentStreams() < (long)this.activeRemoteStreamCount.incrementAndGet()) {
            this.setConnectionTimeoutForStreamCount(this.activeRemoteStreamCount.decrementAndGet());
            return;
        }
        Lock lock = this.socketWrapper.getLock();
        lock.lock();
        try {
            stream2 = this.createLocalStream(request);
            this.writeHeaders(stream, stream2.getIdAsInt(), request.getMimeHeaders(), false, 1024);
        }
        finally {
            lock.unlock();
        }
        stream2.sentPushPromise();
        this.processStreamOnContainerThread(stream2);
    }

    @Override
    protected final String getConnectionId() {
        return this.connectionId;
    }

    void reduceOverheadCount(FrameType frameType) {
        this.updateOverheadCount(frameType, -20);
    }

    @Override
    public void increaseOverheadCount(FrameType frameType) {
        this.updateOverheadCount(frameType, this.getProtocol().getOverheadCountFactor());
    }

    protected void increaseOverheadCount(FrameType frameType, int n) {
        this.updateOverheadCount(frameType, n);
    }

    private void updateOverheadCount(FrameType frameType, int n) {
        long l = this.overheadCount.addAndGet(n);
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.overheadChange", new Object[]{this.connectionId, this.getIdAsString(), frameType.name(), l}));
        }
    }

    boolean isOverheadLimitExceeded() {
        return this.overheadCount.get() > 0L;
    }

    @Override
    public boolean fill(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        boolean bl2 = bl;
        for (int i = n2; i > 0; i -= n3) {
            if (bl2) {
                this.socketWrapper.setReadTimeout(this.protocol.getReadTimeout());
            } else {
                this.socketWrapper.setReadTimeout(-1L);
            }
            n3 = this.socketWrapper.read(bl2, byArray, n4, i);
            if (n3 == 0) {
                if (bl2) {
                    throw new IllegalStateException();
                }
                return false;
            }
            if (n3 == -1) {
                if (this.connectionState.get().isNewStreamAllowed()) {
                    throw new EOFException();
                }
                return false;
            }
            n4 += n3;
            bl2 = true;
        }
        return true;
    }

    @Override
    public int getMaxFrameSize() {
        return this.localSettings.getMaxFrameSize();
    }

    @Override
    public HpackDecoder getHpackDecoder() {
        if (this.hpackDecoder == null) {
            this.hpackDecoder = new HpackDecoder(this.localSettings.getHeaderTableSize());
        }
        return this.hpackDecoder;
    }

    @Override
    public ByteBuffer startRequestBodyFrame(int n, int n2, boolean bl) throws Http2Exception {
        this.reduceOverheadCount(FrameType.DATA);
        if (!bl) {
            int n3 = this.protocol.getOverheadDataThreshold();
            int n4 = (this.lastNonFinalDataPayload >> 1) + (n2 >> 1);
            this.lastNonFinalDataPayload = n2;
            if (n4 == 0) {
                n4 = 1;
            }
            if (n4 < n3) {
                this.increaseOverheadCount(FrameType.DATA, n3 / n4);
            }
        }
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, true);
        abstractNonZeroStream.checkState(FrameType.DATA);
        abstractNonZeroStream.receivedData(n2);
        ByteBuffer byteBuffer = abstractNonZeroStream.getInputByteBuffer(true);
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.startRequestBodyFrame.result", new Object[]{this.getConnectionId(), abstractNonZeroStream.getIdAsString(), byteBuffer}));
        }
        return byteBuffer;
    }

    @Override
    public void endRequestBodyFrame(int n, int n2) throws Http2Exception, IOException {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, true);
        if (abstractNonZeroStream instanceof Stream) {
            ((Stream)abstractNonZeroStream).getInputBuffer().onDataAvailable();
        } else if (n2 > 0) {
            this.onSwallowedDataFramePayload(n, n2);
        }
    }

    @Override
    public void onSwallowedDataFramePayload(int n, int n2) throws IOException {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n);
        this.writeWindowUpdate(abstractNonZeroStream, n2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public HpackDecoder.HeaderEmitter headersStart(int n, boolean bl) throws Http2Exception, IOException {
        Stream stream = this.getStream(n, false);
        if (stream == null) {
            this.checkPauseState();
            if (this.connectionState.get().isNewStreamAllowed()) {
                if (n <= this.maxProcessedStreamId) throw new ConnectionException(sm.getString("upgradeHandler.stream.old", new Object[]{n, this.maxProcessedStreamId}), Http2Error.PROTOCOL_ERROR);
                stream = this.createRemoteStream(n);
                this.activeRemoteStreamCount.incrementAndGet();
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("upgradeHandler.noNewStreams", new Object[]{this.connectionId, Integer.toString(n)}));
                }
                this.reduceOverheadCount(FrameType.HEADERS);
                return HEADER_SINK;
            }
        }
        stream.checkState(FrameType.HEADERS);
        stream.receivedStartOfHeaders(bl);
        return stream;
    }

    @Deprecated
    public void reprioritise(int n, int n2, boolean bl, int n3) throws Http2Exception {
    }

    @Override
    public void headersContinue(int n, boolean bl) {
        int n2;
        if (!bl && n < (n2 = this.getProtocol().getOverheadContinuationThreshold())) {
            if (n == 0) {
                this.increaseOverheadCount(FrameType.CONTINUATION, n2);
            } else {
                this.increaseOverheadCount(FrameType.CONTINUATION, n2 / n);
            }
        }
    }

    @Override
    public void headersEnd(int n, boolean bl) throws Http2Exception {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, this.connectionState.get().isNewStreamAllowed());
        if (abstractNonZeroStream instanceof Stream) {
            boolean bl2 = false;
            this.setMaxProcessedStream(n);
            Stream stream = (Stream)abstractNonZeroStream;
            if (stream.isActive() && stream.receivedEndOfHeaders()) {
                if (this.localSettings.getMaxConcurrentStreams() < (long)this.activeRemoteStreamCount.get()) {
                    this.decrementActiveRemoteStreamCount(stream);
                    this.increaseOverheadCount(FrameType.HEADERS);
                    throw new StreamException(sm.getString("upgradeHandler.tooManyRemoteStreams", new Object[]{Long.toString(this.localSettings.getMaxConcurrentStreams())}), Http2Error.REFUSED_STREAM, n);
                }
                this.reduceOverheadCount(FrameType.HEADERS);
                bl2 = true;
            }
            if (bl) {
                this.receivedEndOfStream(stream);
            }
            if (bl2) {
                this.processStreamOnContainerThread(stream);
            }
        }
    }

    @Override
    public void receivedEndOfStream(int n) throws ConnectionException {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, this.connectionState.get().isNewStreamAllowed());
        if (abstractNonZeroStream instanceof Stream) {
            Stream stream = (Stream)abstractNonZeroStream;
            this.receivedEndOfStream(stream);
        }
    }

    private void receivedEndOfStream(Stream stream) throws ConnectionException {
        stream.receivedEndOfStream();
        if (!stream.isActive()) {
            this.decrementActiveRemoteStreamCount(stream);
        }
    }

    private void setMaxProcessedStream(int n) {
        if (this.maxProcessedStreamId < n) {
            this.maxProcessedStreamId = n;
        }
    }

    @Override
    public void reset(int n, long l) throws Http2Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.reset.receive", new Object[]{this.getConnectionId(), Integer.toString(n), Long.toString(l)}));
        }
        this.increaseOverheadCount(FrameType.RST, this.getProtocol().getOverheadResetFactor());
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, true);
        abstractNonZeroStream.checkState(FrameType.RST);
        if (abstractNonZeroStream instanceof Stream) {
            Stream stream = (Stream)abstractNonZeroStream;
            boolean bl = stream.isActive();
            stream.receiveReset(l);
            if (bl) {
                this.decrementActiveRemoteStreamCount(stream);
            }
        }
    }

    @Override
    public void setting(Setting setting, long l) throws ConnectionException {
        this.increaseOverheadCount(FrameType.SETTINGS);
        if (setting == null) {
            return;
        }
        if (setting == Setting.INITIAL_WINDOW_SIZE) {
            long l2 = this.remoteSettings.getInitialWindowSize();
            this.remoteSettings.set(setting, l);
            int n = (int)(l - l2);
            for (AbstractNonZeroStream abstractNonZeroStream : this.streams.values()) {
                try {
                    abstractNonZeroStream.incrementWindowSize(n);
                }
                catch (Http2Exception http2Exception) {
                    ((Stream)abstractNonZeroStream).close(new StreamException(sm.getString("upgradeHandler.windowSizeTooBig", new Object[]{this.connectionId, abstractNonZeroStream.getIdAsString()}), http2Exception.getError(), abstractNonZeroStream.getIdAsInt()));
                }
            }
        } else if (setting == Setting.NO_RFC7540_PRIORITIES) {
            if (l != 1L) {
                throw new ConnectionException(sm.getString("upgradeHandler.enableRfc7450Priorities", new Object[]{this.connectionId}), Http2Error.PROTOCOL_ERROR);
            }
        } else {
            this.remoteSettings.set(setting, l);
        }
    }

    @Override
    public void settingsEnd(boolean bl) throws IOException {
        if (bl) {
            if (!this.localSettings.ack()) {
                log.warn((Object)sm.getString("upgradeHandler.unexpectedAck", new Object[]{this.connectionId, this.getIdAsString()}));
            }
        } else {
            this.socketWrapper.getLock().lock();
            try {
                this.socketWrapper.write(true, SETTINGS_ACK, 0, SETTINGS_ACK.length);
                this.socketWrapper.flush(true);
            }
            finally {
                this.socketWrapper.getLock().unlock();
            }
        }
    }

    @Override
    public void pingReceive(byte[] byArray, boolean bl) throws IOException {
        if (!bl) {
            this.increaseOverheadCount(FrameType.PING);
        }
        this.pingManager.receivePing(byArray, bl);
    }

    @Override
    public void goaway(int n, long l, String string) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.goaway.debug", new Object[]{this.connectionId, Integer.toString(n), Long.toHexString(l), string}));
        }
        this.close();
    }

    @Override
    public void incrementWindowSize(int n, int n2) throws Http2Exception {
        int n3 = (this.lastWindowUpdate >> 1) + (n2 >> 1);
        int n4 = this.protocol.getOverheadWindowUpdateThreshold();
        this.lastWindowUpdate = n2;
        if (n3 == 0) {
            n3 = 1;
        }
        if (n == 0) {
            if (n3 < n4) {
                this.increaseOverheadCount(FrameType.WINDOW_UPDATE, n4 / n3);
            }
            this.incrementWindowSize(n2);
        } else {
            AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, true);
            if (n3 < n4 && n2 < abstractNonZeroStream.getConnectionAllocationRequested()) {
                this.increaseOverheadCount(FrameType.WINDOW_UPDATE, n4 / n3);
            }
            abstractNonZeroStream.checkState(FrameType.WINDOW_UPDATE);
            abstractNonZeroStream.incrementWindowSize(n2);
        }
    }

    @Override
    public void priorityUpdate(int n, Priority priority) throws Http2Exception {
        this.increaseOverheadCount(FrameType.PRIORITY_UPDATE);
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, true);
        if (abstractNonZeroStream instanceof Stream) {
            Stream stream = (Stream)abstractNonZeroStream;
            stream.setUrgency(priority.getUrgency());
            stream.setIncremental(priority.getIncremental());
        }
    }

    @Override
    public void onSwallowedUnknownFrame(int n, int n2, int n3, int n4) throws IOException {
    }

    void replaceStream(AbstractNonZeroStream abstractNonZeroStream, AbstractNonZeroStream abstractNonZeroStream2) {
        AbstractNonZeroStream abstractNonZeroStream3 = (AbstractNonZeroStream)this.streams.get(abstractNonZeroStream.getIdentifier());
        if (abstractNonZeroStream3 instanceof Stream) {
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("upgradeHandler.replace.first", new Object[]{this.getConnectionId(), abstractNonZeroStream.getIdAsString()}));
            }
            this.streams.put(abstractNonZeroStream.getIdentifier(), abstractNonZeroStream2);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("upgradeHandler.replace.duplicate", new Object[]{this.getConnectionId(), abstractNonZeroStream.getIdAsString()}));
        }
    }

    public ServletConnection getServletConnection() {
        if (this.socketWrapper.getSslSupport() == null) {
            return this.socketWrapper.getServletConnection("h2c", "");
        }
        return this.socketWrapper.getServletConnection("h2", "");
    }

    String getSniHostName() {
        return this.socketWrapper.getSniHostName();
    }

    private static enum ConnectionState {
        NEW(true),
        CONNECTED(true),
        PAUSING(true),
        PAUSED(false),
        CLOSED(false);

        private final boolean newStreamsAllowed;

        private ConnectionState(boolean bl) {
            this.newStreamsAllowed = bl;
        }

        public boolean isNewStreamAllowed() {
            return this.newStreamsAllowed;
        }
    }

    protected class PingManager {
        protected boolean initiateDisabled = false;
        protected final long pingIntervalNano = 10000000000L;
        protected volatile int sequence = 0;
        protected long lastPingNanoTime = Long.MIN_VALUE;
        protected Queue<PingRecord> inflightPings = new ConcurrentLinkedQueue<PingRecord>();
        protected Queue<Long> roundTripTimes = new ConcurrentLinkedQueue<Long>();

        protected PingManager() {
        }

        public void sendPing(boolean bl) throws IOException {
            if (this.initiateDisabled) {
                return;
            }
            long l = System.nanoTime();
            if (bl || l - this.lastPingNanoTime > 10000000000L) {
                this.lastPingNanoTime = l;
                byte[] byArray = new byte[8];
                int n = ++this.sequence;
                PingRecord pingRecord = new PingRecord(n, l);
                this.inflightPings.add(pingRecord);
                ByteUtil.set31Bits(byArray, 4, n);
                Http2UpgradeHandler.this.socketWrapper.write(true, PING, 0, PING.length);
                Http2UpgradeHandler.this.socketWrapper.write(true, byArray, 0, byArray.length);
                Http2UpgradeHandler.this.socketWrapper.flush(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivePing(byte[] byArray, boolean bl) throws IOException {
            if (bl) {
                int n = ByteUtil.get31Bits(byArray, 4);
                PingRecord pingRecord = this.inflightPings.poll();
                while (pingRecord != null && pingRecord.getSequence() < n) {
                    pingRecord = this.inflightPings.poll();
                }
                if (pingRecord != null) {
                    long l = System.nanoTime() - pingRecord.getSentNanoTime();
                    this.roundTripTimes.add(l);
                    while (this.roundTripTimes.size() > 3) {
                        this.roundTripTimes.poll();
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)sm.getString("pingManager.roundTripTime", new Object[]{Http2UpgradeHandler.this.connectionId, l}));
                    }
                }
            } else {
                Http2UpgradeHandler.this.socketWrapper.getLock().lock();
                try {
                    Http2UpgradeHandler.this.socketWrapper.write(true, PING_ACK, 0, PING_ACK.length);
                    Http2UpgradeHandler.this.socketWrapper.write(true, byArray, 0, byArray.length);
                    Http2UpgradeHandler.this.socketWrapper.flush(true);
                }
                finally {
                    Http2UpgradeHandler.this.socketWrapper.getLock().unlock();
                }
            }
        }

        public long getRoundTripTimeNano() {
            return (long)this.roundTripTimes.stream().mapToLong(Long::longValue).average().orElse(0.0);
        }
    }

    protected static interface HeaderFrameBuffers {
        public void startFrame();

        public void endFrame() throws IOException;

        public void endHeaders() throws IOException;

        public byte[] getHeader();

        public ByteBuffer getPayload();

        public void expandPayload();
    }

    private class DefaultHeaderFrameBuffers
    implements HeaderFrameBuffers {
        private final byte[] header = new byte[9];
        private ByteBuffer payload;

        DefaultHeaderFrameBuffers(int n) {
            this.payload = ByteBuffer.allocate(n);
        }

        @Override
        public void startFrame() {
        }

        @Override
        public void endFrame() throws IOException {
            try {
                Http2UpgradeHandler.this.socketWrapper.write(true, this.header, 0, this.header.length);
                Http2UpgradeHandler.this.socketWrapper.write(true, this.payload);
                Http2UpgradeHandler.this.socketWrapper.flush(true);
            }
            catch (IOException iOException) {
                Http2UpgradeHandler.this.handleAppInitiatedIOException(iOException);
            }
            this.payload.clear();
        }

        @Override
        public void endHeaders() {
        }

        @Override
        public byte[] getHeader() {
            return this.header;
        }

        @Override
        public ByteBuffer getPayload() {
            return this.payload;
        }

        @Override
        public void expandPayload() {
            this.payload = ByteBuffer.allocate(this.payload.capacity() * 2);
        }
    }

    protected static class PingRecord {
        private final int sequence;
        private final long sentNanoTime;

        public PingRecord(int n, long l) {
            this.sequence = n;
            this.sentNanoTime = l;
        }

        public int getSequence() {
            return this.sequence;
        }

        public long getSentNanoTime() {
            return this.sentNanoTime;
        }
    }
}

