/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.digest;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.digest.Digest;

public class BaseDigest
implements Digest {
    private final String algorithm;
    private final int bsize;
    private MessageDigest md;

    public BaseDigest(String algorithm, int bsize) {
        this.algorithm = algorithm;
        this.bsize = bsize;
    }

    @Override
    public byte[] digest() {
        return this.md.digest();
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init() {
        try {
            this.md = SecurityUtils.getMessageDigest(this.algorithm);
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException(e);
        }
    }

    @Override
    public void update(byte[] foo) {
        this.update(foo, 0, foo.length);
    }

    @Override
    public void update(byte[] foo, int start, int len) {
        this.md.update(foo, start, len);
    }
}

