/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GtkTargetEntry;
import org.eclipse.swt.widgets.Display;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    long clipboardOwner = GTK3.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(Display display) {
        if (GTK.GTK4) {
            throw new UnsupportedOperationException("Illegal attempt to use GTK3 ClipboardProxy on GTK4");
        }
        ClipboardProxy proxy = (ClipboardProxy)display.getData(ID);
        if (proxy != null) {
            return proxy;
        }
        proxy = new ClipboardProxy(display);
        display.setData(ID, proxy);
        display.disposeExec(() -> {
            ClipboardProxy clipbordProxy = (ClipboardProxy)display.getData(ID);
            if (clipbordProxy == null) {
                return;
            }
            display.setData(ID, null);
            clipbordProxy.dispose();
        });
        return proxy;
    }

    private ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        this.clearFunc = new Callback(this, "clearFunc", 2);
    }

    void clear(Clipboard owner, int clipboards) {
        if ((clipboards & 1) != 0 && this.activeClipboard == owner) {
            this.gtk_gdk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if ((clipboards & 2) != 0 && this.activePrimaryClipboard == owner) {
            this.gtk_gdk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    void gtk_gdk_clipboard_clear(long clipboard) {
        GTK3.gtk_clipboard_clear(clipboard);
    }

    private void finishDispose() {
        if (this.display == null && this.clipboardDataTypes == null && this.primaryClipboardDataTypes == null) {
            if (this.getFunc != null) {
                this.getFunc.dispose();
            }
            this.getFunc = null;
            if (this.clearFunc != null) {
                this.clearFunc.dispose();
            }
            this.clearFunc = null;
            if (this.clipboardOwner != 0L) {
                GTK3.gtk_widget_destroy(this.clipboardOwner);
            }
            this.clipboardOwner = 0L;
        }
    }

    long clearFunc(long clipboard, long user_data_or_owner) {
        if (this.display == null) {
            System.err.println("***WARNING: Attempt to access SWT clipboard after disposing SWT Display.");
        }
        if (clipboard == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (clipboard == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        this.finishDispose();
        return 1L;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null) {
            GTK3.gtk_clipboard_store(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null) {
            GTK3.gtk_clipboard_store(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        this.finishDispose();
    }

    long getFunc(long clipboard, long selection_data, long info, long user_data_or_owner) {
        if (this.display == null) {
            System.err.println("***WARNING: Attempt to access SWT clipboard after disposing SWT Display.");
            return 0L;
        }
        if (selection_data == 0L) {
            return 0L;
        }
        long target = GTK3.gtk_selection_data_get_target(selection_data);
        TransferData tdata = new TransferData();
        tdata.type = target;
        Transfer[] types = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int index = -1;
        int i = 0;
        while (i < types.length) {
            if (types[i].isSupportedType(tdata)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return 0L;
        }
        Object[] data = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        types[index].javaToNative(data[index], tdata);
        if (tdata.format < 8 || tdata.format % 8 != 0) {
            return 0L;
        }
        GTK3.gtk_selection_data_set(selection_data, tdata.type, tdata.format, tdata.pValue, tdata.length);
        OS.g_free(tdata.pValue);
        return 1L;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setData(Clipboard owner, Object[] data, Transfer[] dataTypes, int clipboards) {
        entries = new GtkTargetEntry[]{};
        pTargetsList = 0L;
        try {
            i = 0;
            while (i < dataTypes.length) {
                transfer = dataTypes[i];
                typeIds = transfer.getTypeIds();
                typeNames = transfer.getTypeNames();
                j = 0;
                while (j < typeIds.length) {
                    entry = new GtkTargetEntry();
                    entry.info = typeIds[j];
                    buffer = Converter.wcsToMbcs(typeNames[j], true);
                    pName = OS.g_malloc(buffer.length);
                    C.memmove(pName, buffer, (long)buffer.length);
                    entry.target = pName;
                    tmp = new GtkTargetEntry[entries.length + 1];
                    System.arraycopy(entries, 0, tmp, 0, entries.length);
                    tmp[entries.length] = entry;
                    entries = tmp;
                    ++j;
                }
                ++i;
            }
            pTargetsList = OS.g_malloc(GtkTargetEntry.sizeof * entries.length);
            offset = 0;
            i = 0;
            while (i < entries.length) {
                GTK3.memmove(pTargetsList + (long)offset, entries[i], (long)GtkTargetEntry.sizeof);
                offset += GtkTargetEntry.sizeof;
                ++i;
            }
            if ((clipboards & 1) != 0) {
                this.clipboardData = data;
                this.clipboardDataTypes = dataTypes;
                getFuncProc = this.getFunc.getAddress();
                if (!GTK3.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, pTargetsList, entries.length, getFuncProc, clearFuncProc = this.clearFunc.getAddress(), this.clipboardOwner)) {
                }
                GTK3.gtk_clipboard_set_can_store(Clipboard.GTKCLIPBOARD, 0L, 0);
                this.activeClipboard = owner;
            }
            if ((clipboards & 2) != 0) {
                this.primaryClipboardData = data;
                this.primaryClipboardDataTypes = dataTypes;
                getFuncProc = this.getFunc.getAddress();
                if (!GTK3.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, pTargetsList, entries.length, getFuncProc, clearFuncProc = this.clearFunc.getAddress(), this.clipboardOwner)) {
                }
                GTK3.gtk_clipboard_set_can_store(Clipboard.GTKPRIMARYCLIPBOARD, 0L, 0);
                this.activePrimaryClipboard = owner;
                return (boolean)this.activePrimaryClipboard;
            }
        }
        finally {
            i = 0;
            ** while (i < entries.length)
        }
lbl-1000:
        // 1 sources

        {
            entry = entries[i];
            if (entry.target != 0L) {
                OS.g_free(entry.target);
            }
            ++i;
            continue;
        }
lbl59:
        // 1 sources

        if (pTargetsList == 0L) return false;
        OS.g_free(pTargetsList);
        return false;
    }
}

