/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math;

import com.jogamp.math.FloatUtil;
import com.jogamp.math.Vec2i;
import com.jogamp.math.Vec3f;

public final class Vec2f {
    private float x;
    private float y;

    public static Vec2f from_length_angle(float f, float f2) {
        return new Vec2f((float)((double)f * Math.cos(f2)), (float)((double)f * Math.sin(f2)));
    }

    public Vec2f() {
    }

    public Vec2f(Vec2f vec2f) {
        this.set(vec2f);
    }

    public Vec2f(Vec2i vec2i) {
        this.set(vec2i);
    }

    public Vec2f(Vec3f vec3f) {
        this.set(vec3f);
    }

    public Vec2f copy() {
        return new Vec2f(this);
    }

    public Vec2f(float[] fArray) {
        this.set(fArray);
    }

    public Vec2f(float f, float f2) {
        this.set(f, f2);
    }

    public void set(Vec2f vec2f) {
        this.x = vec2f.x;
        this.y = vec2f.y;
    }

    public void set(Vec2i vec2i) {
        this.x = vec2i.x();
        this.y = vec2i.y();
    }

    public void set(Vec3f vec3f) {
        this.x = vec3f.x();
        this.y = vec3f.y();
    }

    public void set(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Vec2f set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        return this;
    }

    public Vec2f toArray(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        return this;
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public float[] get(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        return fArray;
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public Vec2f max(Vec2f vec2f) {
        this.x = Math.max(this.x, vec2f.x);
        this.y = Math.max(this.y, vec2f.y);
        return this;
    }

    public Vec2f min(Vec2f vec2f) {
        this.x = Math.min(this.x, vec2f.x);
        this.y = Math.min(this.y, vec2f.y);
        return this;
    }

    public Vec2f mul(float f) {
        return new Vec2f(this).scale(f);
    }

    public Vec2f mul(Vec2f vec2f, Vec2f vec2f2) {
        this.x = vec2f.x * vec2f2.x;
        this.y = vec2f.y * vec2f2.y;
        return this;
    }

    public Vec2f mul(Vec2f vec2f) {
        return this.mul(vec2f.x, vec2f.y);
    }

    public Vec2f mul(float f, float f2) {
        this.x *= f;
        this.y *= f2;
        return this;
    }

    public Vec2f div(Vec2f vec2f, Vec2f vec2f2) {
        this.x = vec2f.x / vec2f2.x;
        this.y = vec2f.y / vec2f2.y;
        return this;
    }

    public Vec2f div(Vec2f vec2f) {
        this.x /= vec2f.x;
        this.y /= vec2f.y;
        return this;
    }

    public Vec2f scale(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public Vec2f plus(Vec2f vec2f) {
        return new Vec2f(this).add(vec2f);
    }

    public Vec2f plus(Vec2f vec2f, Vec2f vec2f2) {
        this.x = vec2f.x + vec2f2.x;
        this.y = vec2f.y + vec2f2.y;
        return this;
    }

    public Vec2f add(float f, float f2) {
        this.x += f;
        this.y += f2;
        return this;
    }

    public Vec2f add(Vec2f vec2f) {
        this.x += vec2f.x;
        this.y += vec2f.y;
        return this;
    }

    public Vec2f minus(Vec2f vec2f) {
        return new Vec2f(this).sub(vec2f);
    }

    public Vec2f minus(Vec2f vec2f, Vec2f vec2f2) {
        this.x = vec2f.x - vec2f2.x;
        this.y = vec2f.y - vec2f2.y;
        return this;
    }

    public Vec2f sub(Vec2f vec2f) {
        this.x -= vec2f.x;
        this.y -= vec2f.y;
        return this;
    }

    public boolean isZero() {
        return FloatUtil.isZero(this.x) && FloatUtil.isZero(this.y);
    }

    public void rotate(float f, Vec2f vec2f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.rotate(f3, f2, vec2f);
    }

    public void rotate(float f, float f2, Vec2f vec2f) {
        float f3 = this.x - vec2f.x;
        float f4 = this.y - vec2f.y;
        float f5 = f3 * f2 - f4 * f + vec2f.x;
        this.y = f3 * f + f4 * f2 + vec2f.y;
        this.x = f5;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSq());
    }

    public float lengthSq() {
        return this.x * this.x + this.y * this.y;
    }

    public float angle() {
        return (float)Math.atan2(this.y, this.x);
    }

    public Vec2f normalize() {
        float f = this.lengthSq();
        if (FloatUtil.isZero(f)) {
            this.x = 0.0f;
            this.y = 0.0f;
        } else {
            float f2 = 1.0f / (float)Math.sqrt(f);
            this.x *= f2;
            this.y *= f2;
        }
        return this;
    }

    public float distSq(Vec2f vec2f) {
        float f = this.x - vec2f.x;
        float f2 = this.y - vec2f.y;
        return f * f + f2 * f2;
    }

    public float dist(Vec2f vec2f) {
        return (float)Math.sqrt(this.distSq(vec2f));
    }

    public float dot(Vec2f vec2f) {
        return this.x * vec2f.x + this.y * vec2f.y;
    }

    public float cross(Vec2f vec2f) {
        return this.x * vec2f.y - this.y * vec2f.x;
    }

    public float cosAngle(Vec2f vec2f) {
        return this.dot(vec2f) / (this.length() * vec2f.length());
    }

    public float angle(Vec2f vec2f) {
        return (float)Math.acos(this.cosAngle(vec2f));
    }

    public Vec2f normal_ccw() {
        return new Vec2f(-this.y, this.x);
    }

    public boolean isEqual(Vec2f vec2f, float f) {
        if (this == vec2f) {
            return true;
        }
        return FloatUtil.isEqual(this.x, vec2f.x, f) && FloatUtil.isEqual(this.y, vec2f.y, f);
    }

    public boolean isEqual(Vec2f vec2f) {
        if (this == vec2f) {
            return true;
        }
        return FloatUtil.isEqual(this.x, vec2f.x) && FloatUtil.isEqual(this.y, vec2f.y);
    }

    public boolean equals(Object object) {
        if (object instanceof Vec2f) {
            return this.isEqual((Vec2f)object);
        }
        return false;
    }

    public String toString() {
        return this.x + " / " + this.y;
    }
}

