/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend;

import com.intellij.ide.actions.searcheverywhere.SearchEverywherePopupInstance;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.ide.actions.searcheverywhere.SplitSearchListener;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.platform.searchEverywhere.frontend.SeFilterEditor;
import com.intellij.platform.searchEverywhere.frontend.SeSearchStatePublisher;
import com.intellij.platform.searchEverywhere.frontend.ui.SePopupContentPane;
import com.intellij.platform.searchEverywhere.frontend.vm.SePopupVm;
import com.intellij.platform.searchEverywhere.providers.SeLog;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u0011J\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u001f\u001a\u00020\rJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\rH\u0017J*\u0010#\u001a\u00020\r2 \u0010$\u001a\u001c\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0'\u0012\u0006\u0012\u0004\u0018\u00010&0%H\u0017J\u001c\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0'0)2\u0006\u0010+\u001a\u00020\u0011H\u0017J\u0006\u0010,\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010-\u001a\u0004\u0018\u00010.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/SePopupInstance;", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywherePopupInstance;", "popupVm", "Lcom/intellij/platform/searchEverywhere/frontend/vm/SePopupVm;", "popupContentPane", "Lcom/intellij/platform/searchEverywhere/frontend/ui/SePopupContentPane;", "combinedListener", "Lcom/intellij/platform/searchEverywhere/frontend/SeSearchStatePublisher;", "<init>", "(Lcom/intellij/platform/searchEverywhere/frontend/vm/SePopupVm;Lcom/intellij/platform/searchEverywhere/frontend/ui/SePopupContentPane;Lcom/intellij/platform/searchEverywhere/frontend/SeSearchStatePublisher;)V", "registerShortcut", "Lkotlin/Function1;", "Lcom/intellij/openapi/actionSystem/AnAction;", "", "getRegisterShortcut", "()Lkotlin/jvm/functions/Function1;", "getSearchText", "", "setSearchText", "searchText", "getSearchFieldDocument", "Ljavax/swing/text/Document;", "closePopup", "addSearchListener", "listener", "Lcom/intellij/ide/actions/searcheverywhere/SearchListener;", "addSplitSearchListener", "Lcom/intellij/ide/actions/searcheverywhere/SplitSearchListener;", "getSelectedTabID", "setSelectedTabID", "tabID", "toggleEverywhereFilter", "isEverywhere", "", "selectFirstItem", "changeScope", "processor", "Lkotlin/Function2;", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "", "findElementsForPattern", "Ljava/util/concurrent/Future;", "", "pattern", "saveSearchText", "currentTabSearchEverywhereToggleAction", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereToggleAction;", "getCurrentTabSearchEverywhereToggleAction", "()Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereToggleAction;", "intellij.platform.searchEverywhere.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSePopupInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SePopupInstance.kt\ncom/intellij/platform/searchEverywhere/frontend/SePopupInstance\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n295#2,2:91\n*S KotlinDebug\n*F\n+ 1 SePopupInstance.kt\ncom/intellij/platform/searchEverywhere/frontend/SePopupInstance\n*L\n87#1:91,2\n*E\n"})
public final class SePopupInstance
implements SearchEverywherePopupInstance {
    @NotNull
    private final SePopupVm popupVm;
    @NotNull
    private final SePopupContentPane popupContentPane;
    @NotNull
    private final SeSearchStatePublisher combinedListener;
    @NotNull
    private final Function1<AnAction, Unit> registerShortcut;

    public SePopupInstance(@NotNull SePopupVm popupVm2, @NotNull SePopupContentPane popupContentPane, @NotNull SeSearchStatePublisher combinedListener) {
        Intrinsics.checkNotNullParameter((Object)popupVm2, (String)"popupVm");
        Intrinsics.checkNotNullParameter((Object)popupContentPane, (String)"popupContentPane");
        Intrinsics.checkNotNullParameter((Object)combinedListener, (String)"combinedListener");
        this.popupVm = popupVm2;
        this.popupContentPane = popupContentPane;
        this.combinedListener = combinedListener;
        this.registerShortcut = arg_0 -> SePopupInstance.registerShortcut$lambda$0(this, arg_0);
    }

    @NotNull
    public final Function1<AnAction, Unit> getRegisterShortcut() {
        return this.registerShortcut;
    }

    @NotNull
    public String getSearchText() {
        return (String)this.popupVm.getSearchPattern().getValue();
    }

    public void setSearchText(@Nullable String searchText) {
        String string = searchText;
        if (string == null) {
            string = "";
        }
        this.popupVm.setSearchText(string);
    }

    @NotNull
    public Document getSearchFieldDocument() {
        return this.popupContentPane.getSearchFieldDocument();
    }

    public void closePopup() {
        this.popupVm.closePopup();
    }

    public void addSearchListener(@NotNull SearchListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        SeLog.Companion.warn("SearchListener is not supported in the split implementation. Please, use addSplitSearchListener instead.");
    }

    public void addSplitSearchListener(@NotNull SplitSearchListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.combinedListener.addListener(listener);
    }

    @NotNull
    public final String getSelectedTabID() {
        return this.popupVm.getCurrentTab().getTabId();
    }

    public final void setSelectedTabID(@NotNull String tabID) {
        Intrinsics.checkNotNullParameter((Object)tabID, (String)"tabID");
        this.popupVm.showTab(tabID);
    }

    public final void toggleEverywhereFilter() {
        SearchEverywhereToggleAction searchEverywhereToggleAction = this.getCurrentTabSearchEverywhereToggleAction();
        if (searchEverywhereToggleAction == null) {
            return;
        }
        SearchEverywhereToggleAction action2 = searchEverywhereToggleAction;
        if (action2.canToggleEverywhere()) {
            action2.setEverywhere(!action2.isEverywhere());
        }
    }

    public final boolean isEverywhere() {
        SearchEverywhereToggleAction searchEverywhereToggleAction = this.getCurrentTabSearchEverywhereToggleAction();
        return searchEverywhereToggleAction != null ? searchEverywhereToggleAction.isEverywhere() : true;
    }

    @ApiStatus.Internal
    public void selectFirstItem() {
        this.popupContentPane.selectFirstItem();
    }

    @ApiStatus.Internal
    public void changeScope(@NotNull Function2<? super ScopeDescriptor, ? super List<? extends ScopeDescriptor>, ? extends ScopeDescriptor> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @ApiStatus.Internal
    @TestOnly
    @NotNull
    public Future<List<Object>> findElementsForPattern(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public final void saveSearchText() {
        this.popupVm.saveSearchText();
    }

    private final SearchEverywhereToggleAction getCurrentTabSearchEverywhereToggleAction() {
        AnAction anAction;
        Object object = (SeFilterEditor)this.popupVm.getCurrentTab().getFilterEditor().getValueOrNull();
        if (object != null && (object = object.getHeaderActions()) != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AnAction it = (AnAction)element$iv;
                    boolean bl = false;
                    if (!(it instanceof SearchEverywhereToggleAction)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            anAction = v1;
        } else {
            anAction = null;
        }
        AnAction anAction2 = anAction;
        return anAction2 instanceof SearchEverywhereToggleAction ? (SearchEverywhereToggleAction)anAction2 : null;
    }

    private static final Unit registerShortcut$lambda$0(SePopupInstance this$0, AnAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        ShortcutSet shortcut = ActionUtil.getMnemonicAsShortcut((AnAction)action2);
        if (shortcut != null) {
            action2.setShortcutSet(shortcut);
            action2.registerCustomShortcutSet(shortcut, (JComponent)this$0.popupContentPane);
        }
        return Unit.INSTANCE;
    }
}

