/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.NativeServerManager;
import com.jetbrains.cef.remote.ThriftTransport;
import com.jetbrains.cef.remote.browser.RemoteClient;
import com.jetbrains.cef.remote.callback.RemoteSchemeHandlerFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.SystemBootstrap;
import org.cef.browser.CefRendering;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;
import org.cef.handler.CefAppStateHandler;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class CefApp
extends CefAppHandlerAdapter {
    private static CefApp self = null;
    private static CefAppHandler userAppHandler_ = null;
    private static final CompletableFuture<Void> ourStartupFeature = new CompletableFuture();
    private final CefAppHandler appHandler_;
    private CefAppState state_ = CefAppState.NONE;
    private Timer workTimer_ = null;
    private final HashSet<CefClient> clients_ = new HashSet();
    private CefSettings settings_ = null;
    private final CefServer server_;
    private volatile boolean isInitialized_ = false;
    private final LinkedList<CefAppStateHandler> initializationListeners_ = new LinkedList();
    private static final boolean PREINIT_ON_ANY_THREAD = Utils.getBoolean("jcef_app_preinit_any");
    private static final int PREINIT_TEST_DELAY_MS = Utils.getInteger("jcef_app_preinit_test_delay_ms", 0);
    private static final int INIT_TEST_DELAY_MS = Utils.getInteger("jcef_app_init_test_delay_ms", 0);
    private static final boolean IS_REMOTE_ENABLED = CefApp.isRemoteSupported() ? Boolean.getBoolean("jcef.remote.enabled") : false;

    private CefApp(String[] args, CefSettings settings, CefServer server) {
        super(args);
        this.appHandler_ = userAppHandler_;
        userAppHandler_ = null;
        if (settings != null) {
            this.settings_ = settings.clone();
        }
        this.setState(CefAppState.NEW);
        this.server_ = server;
        if (this.server_ != null) {
            this.server_.setCefApp(this);
            new Thread(() -> {
                if (this.server_.start(this.appHandler_)) {
                    CefLog.Debug("%s: native CefServer is initialized.", this);
                    this.setState(CefAppState.INITIALIZED);
                    LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
                    synchronized (linkedList) {
                        this.isInitialized_ = true;
                        this.initializationListeners_.forEach(l -> l.stateHasChanged(CefAppState.INITIALIZED));
                        this.initializationListeners_.clear();
                    }
                    CefLog.Info("%s: connected to CefServer. JCEF version: %s", this, this.getVersion());
                }
            }, "CefInitialize-thread").start();
            return;
        }
        ourStartupFeature.thenRunAsync(() -> {
            this.preinit(args);
            this.initialize();
        }, new NamedThreadExecutor("CefInitialize-thread"));
    }

    private void preinit(String[] args) throws RuntimeException {
        AtomicBoolean success = new AtomicBoolean(false);
        if (PREINIT_ON_ANY_THREAD) {
            success.set(this.N_PreInitialize());
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> success.set(this.N_PreInitialize()));
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException("Failed to do JCEF preinit", e);
            }
        }
        if (!success.get()) {
            throw new RuntimeException("Failed to do JCEF preinit");
        }
    }

    public void onInitialization(CefAppStateHandler initListener) {
        this.onInitialization(initListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitialization(CefAppStateHandler initListener, boolean first) {
        LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
        synchronized (linkedList) {
            if (this.isInitialized_) {
                initListener.stateHasChanged(CefAppState.INITIALIZED);
            } else if (first) {
                this.initializationListeners_.addFirst(initListener);
            } else {
                this.initializationListeners_.addLast(initListener);
            }
        }
    }

    public static void addAppHandler(CefAppHandler appHandler) throws IllegalStateException {
        if (self != null && !IS_REMOTE_ENABLED) {
            throw new IllegalStateException("Must be called before CefApp is initialized");
        }
        userAppHandler_ = appHandler;
    }

    public static void setDefaultRenderingFactory(Supplier<CefRendering> factory) {
        RemoteClient.setDefaultRenderingFactory(factory);
    }

    public static synchronized CefApp getInstance() {
        if (IS_REMOTE_ENABLED && self != null) {
            return self;
        }
        return CefApp.getInstance(null, null);
    }

    public static synchronized CefApp getInstance(String[] args) {
        return CefApp.getInstance(args, null);
    }

    public static synchronized CefApp getInstance(CefSettings settings) {
        return CefApp.getInstance(null, settings);
    }

    public static synchronized CefApp getInstance(String[] args, CefSettings settings) {
        if (IS_REMOTE_ENABLED) {
            String[] realArgs;
            if (args != null && args.length > 0) {
                realArgs = args;
            } else if (userAppHandler_ instanceof CefAppHandlerAdapter) {
                realArgs = ((CefAppHandlerAdapter)userAppHandler_).getArgs();
            } else {
                if (userAppHandler_ != null) {
                    CefLog.Error("Unsupported class of CefAppHandler %s. Overridden command-line arguments will be ignored.", CefAppHandler.class);
                }
                realArgs = null;
            }
            CefServer s = CefServer.findInstance(realArgs, settings);
            if (s != null) {
                return s.getCefApp();
            }
            ThriftTransport st = ThriftTransport.ourDefaultServer;
            ThriftTransport ct = ThriftTransport.ourDefaultClient;
            if (CefServer.getInstancesCount() > 0) {
                if (ThriftTransport.isTcpUsed()) {
                    ct = new ThriftTransport(ThriftTransport.findFreePort(null));
                    HashSet<Integer> exclude = new HashSet<Integer>();
                    exclude.add(ct.getPort());
                    st = new ThriftTransport(ThriftTransport.findFreePort(exclude));
                } else {
                    String suffix = "" + System.currentTimeMillis();
                    ct = new ThriftTransport(ThriftTransport.getJavaHandlersPipe(suffix));
                    st = new ThriftTransport(ThriftTransport.getServerPipe(suffix));
                }
            }
            s = new CefServer(st, ct, realArgs, settings);
            CefApp result = new CefApp(realArgs, settings, s);
            if (self == null) {
                self = result;
            }
            return result;
        }
        if (settings != null && self != null) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time. Current state is " + CefApp.self.state_);
        }
        if (self == null) {
            self = new CefApp(args, settings, null);
        } else if (self.isTerminated()) {
            throw new IllegalStateException("CefApp was terminated");
        }
        return self;
    }

    public static synchronized CefApp findInstance(String[] args, CefSettings settings) {
        if (!IS_REMOTE_ENABLED) {
            return null;
        }
        CefServer s = CefServer.findInstance(args, settings);
        return s != null ? s.getCefApp() : null;
    }

    public static synchronized CefApp getInstanceIfAny() {
        return self;
    }

    public static synchronized void setDefaultInstance(CefApp cefApp) {
        self = cefApp;
    }

    public final synchronized void setSettings(CefSettings settings) throws IllegalStateException {
        if (this.state_.compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time. Current state is " + this.state_);
        }
        this.settings_ = settings.clone();
    }

    public final CefVersion getVersion() {
        if (this.server_ != null) {
            return new CefVersion(0, "0", 0, 0, 0, 0, 0, 0, 0, 0){

                @Override
                public String toString() {
                    return "remote_" + CefApp.this.server_.getVersion();
                }

                @Override
                public String getJcefVersion() {
                    return "remote_" + CefApp.this.server_.getVersion();
                }
            };
        }
        try {
            return this.N_GetVersion();
        }
        catch (UnsatisfiedLinkError ule) {
            CefLog.Error("Failed to get CEF version. %s", ule.getMessage());
            return null;
        }
    }

    public static final boolean isRemoteSupported() {
        return NativeServerManager.isRemoteSupported();
    }

    public static final boolean isRemoteEnabled() {
        return IS_REMOTE_ENABLED;
    }

    public final CefServer getServer() {
        return this.server_;
    }

    public String toString() {
        if (this.server_ == null) {
            return "CefApp";
        }
        return "CefApp(" + this.server_.toStringShort() + ")";
    }

    public static CefAppState getState() {
        CefApp app = self;
        return app == null ? CefAppState.NONE : app.state_;
    }

    public synchronized boolean isTerminated() {
        return this.state_ == CefAppState.TERMINATED;
    }

    private synchronized void setState(final CefAppState state) {
        if (state.compareTo(this.state_) < 0) {
            String errMsg = this + ": state cannot go backward. Current state " + this.state_ + ". Proposed state " + state;
            CefLog.Error(errMsg, new Object[0]);
            throw new IllegalStateException(errMsg);
        }
        CefLog.Info("%s: set state %s", new Object[]{this, state});
        this.state_ = state;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefAppHandler handler;
                CefAppHandler cefAppHandler = handler = CefApp.this.appHandler_ == null ? CefApp.this : CefApp.this.appHandler_;
                if (handler != null) {
                    handler.stateHasChanged(state);
                }
            }
        });
    }

    public final synchronized void dispose() {
        switch (this.state_) {
            case NEW: {
                this.setState(CefAppState.TERMINATED);
                break;
            }
            case INITIALIZING: 
            case INITIALIZED: {
                this.setState(CefAppState.SHUTTING_DOWN);
                if (this.clients_.isEmpty()) {
                    this.finishShutdown();
                    break;
                }
                CefLog.Debug("%s: dispose clients before shutting down", this);
                HashSet<CefClient> clients = new HashSet<CefClient>(this.clients_);
                for (CefClient c : clients) {
                    CefLog.Debug("%s: dispose client %s", this, c);
                    c.dispose();
                }
                break;
            }
        }
    }

    public synchronized CefClient createClient() {
        if (this.state_.compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            String errMsg = this + ": can't create client in state " + this.state_;
            CefLog.Error(errMsg, new Object[0]);
            throw new IllegalStateException(errMsg);
        }
        CefClient client = this.server_ != null ? new CefClient(this.server_.createClient()) : new CefClient();
        this.onInitialization(client, true);
        this.clients_.add(client);
        return client;
    }

    public boolean registerSchemeHandlerFactory(String schemeName, String domainName, CefSchemeHandlerFactory factory) {
        if (this.server_ != null) {
            this.server_.onConnected(() -> {
                RemoteSchemeHandlerFactory rf = RemoteSchemeHandlerFactory.create(factory);
                this.server_.exec(s -> s.SchemeHandlerFactory_Register(schemeName, domainName, rf.thriftId()));
            }, "registerSchemeHandlerFactory", true);
            return true;
        }
        this.onInitialization(state -> {
            if (!this.N_RegisterSchemeHandlerFactory(schemeName, domainName, factory)) {
                CefLog.Error("Can't register scheme [%s:%s]", schemeName, domainName);
            }
        });
        return true;
    }

    public boolean clearSchemeHandlerFactories() {
        if (this.server_ != null) {
            this.server_.onConnected(() -> this.server_.exec(s -> s.ClearAllSchemeHandlerFactories()), "clearSchemeHandlerFactories", false);
            return true;
        }
        if (!this.isInitialized_) {
            return false;
        }
        return this.N_ClearSchemeHandlerFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void clientWasDisposed(CefClient client) {
        this.clients_.remove(client);
        LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
        synchronized (linkedList) {
            this.initializationListeners_.remove(client);
        }
        CefLog.Debug("%s: client was disposed: %s [clients count %d]", this, client, this.clients_.size());
        if (this.clients_.isEmpty() && this.state_.compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            this.finishShutdown();
        }
    }

    private static void testSleep(int ms) {
        if (ms > 0) {
            CefLog.Debug("testSleep %s ms", ms);
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.setState(CefAppState.INITIALIZING);
        CefApp.testSleep(INIT_TEST_DELAY_MS);
        String logMsg = "Initialize CefApp on " + Thread.currentThread();
        if (this.settings_.log_severity == CefSettings.LogSeverity.LOGSEVERITY_INFO || this.settings_.log_severity == CefSettings.LogSeverity.LOGSEVERITY_VERBOSE) {
            CefLog.Info(logMsg, new Object[0]);
        } else {
            CefLog.Debug(logMsg, new Object[0]);
        }
        CefSettings settings = this.settings_ != null ? this.settings_ : new CefSettings();
        boolean success = this.N_Initialize(this.appHandler_ == null ? this : this.appHandler_, settings, false);
        if (success) {
            CefLog.Debug("CefApp: native initialization is finished.", new Object[0]);
            this.setState(CefAppState.INITIALIZED);
            LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
            synchronized (linkedList) {
                this.isInitialized_ = true;
                this.initializationListeners_.forEach(l -> l.stateHasChanged(CefAppState.INITIALIZED));
                this.initializationListeners_.clear();
            }
            CefLog.Info("version: %s | settings: %s", this.getVersion(), settings.getDescription());
        } else {
            CefLog.Error("CefApp: N_Initialize failed.", new Object[0]);
        }
    }

    private void finishShutdown() {
        if (this.server_ != null) {
            this.server_.stop();
            this.setState(CefAppState.TERMINATED);
            return;
        }
        new Thread(() -> {
            int sleepBeforeShutdown = Utils.getInteger("JCEF_SLEEP_BEFORE_SHUTDOWN", 999);
            if (sleepBeforeShutdown > 0) {
                try {
                    CefLog.Debug("Sleep before native shutdown for %d ms, thread %s.", sleepBeforeShutdown, Thread.currentThread());
                    Thread.sleep(sleepBeforeShutdown);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            CefLog.Info("Perform native shutdown of CEF on thread %s.", Thread.currentThread());
            this.N_Shutdown();
            this.setState(CefAppState.TERMINATED);
        }, "CEF-shutdown-thread").start();
    }

    public final void doMessageLoopWork(final long delay_ms) {
        if (this.server_ != null) {
            CefLog.Error("doMessageLoopWork musn't be called in remote mode.", new Object[0]);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CefApp.this.isTerminated()) {
                    return;
                }
                long kMaxTimerDelay = 33L;
                if (CefApp.this.workTimer_ != null) {
                    CefApp.this.workTimer_.stop();
                    CefApp.this.workTimer_ = null;
                }
                if (delay_ms <= 0L) {
                    CefApp.this.N_DoMessageLoopWork();
                    CefApp.this.doMessageLoopWork(33L);
                } else {
                    long timer_delay_ms = delay_ms;
                    if (timer_delay_ms > 33L) {
                        timer_delay_ms = 33L;
                    }
                    CefApp.this.workTimer_ = new Timer((int)timer_delay_ms, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            CefApp.this.workTimer_.stop();
                            CefApp.this.workTimer_ = null;
                            CefApp.this.N_DoMessageLoopWork();
                            CefApp.this.doMessageLoopWork(33L);
                        }
                    });
                    CefApp.this.workTimer_.start();
                }
            }
        });
    }

    public static boolean startup(String[] args) {
        if (IS_REMOTE_ENABLED) {
            return true;
        }
        if (OS.isMacintosh() && args.length == 0) {
            CefApp.startupAsync(JCefAppConfig.getJbrFrameworkPathOSX());
            return true;
        }
        String frameworkPathOSX = null;
        String switchPrefix = "--framework-dir-path=";
        for (String arg : args) {
            if (!arg.startsWith(switchPrefix)) continue;
            frameworkPathOSX = new File(arg.substring(switchPrefix.length())).getAbsolutePath();
        }
        CefApp.startupAsync(frameworkPathOSX);
        return true;
    }

    @Deprecated(forRemoval=true)
    public static void startupAsync() {
        CefApp.startupAsync(JCefAppConfig.getJbrFrameworkPathOSX());
    }

    public static void startupAsync(String frameworkPath) {
        if (IS_REMOTE_ENABLED) {
            return;
        }
        new NamedThreadExecutor("CefStartup-thread").execute(() -> {
            try {
                if (OS.isWindows()) {
                    try {
                        SystemBootstrap.loadLibrary("jawt");
                    }
                    catch (UnsatisfiedLinkError e) {
                        CefLog.Error("can't load jawt library: " + e.getMessage(), new Object[0]);
                    }
                    SystemBootstrap.loadLibrary("chrome_elf");
                    SystemBootstrap.loadLibrary("libcef");
                } else if (OS.isLinux()) {
                    SystemBootstrap.loadLibrary("cef");
                }
                SystemBootstrap.loadLibrary("jcef");
                CefApp.N_Startup(frameworkPath);
                ourStartupFeature.complete(null);
            }
            catch (Throwable e) {
                ourStartupFeature.completeExceptionally(e);
            }
        });
    }

    private static native boolean N_Startup(String var0);

    private native boolean N_PreInitialize();

    private native boolean N_Initialize(CefAppHandler var1, CefSettings var2, boolean var3);

    private native void N_Shutdown();

    private native void N_DoMessageLoopWork();

    private native CefVersion N_GetVersion();

    private native boolean N_RegisterSchemeHandlerFactory(String var1, String var2, CefSchemeHandlerFactory var3);

    private native boolean N_ClearSchemeHandlerFactories();

    public static enum CefAppState {
        NONE,
        NEW,
        INITIALIZING,
        INITIALIZED,
        SHUTTING_DOWN,
        TERMINATED;

    }

    static class NamedThreadExecutor
    implements Executor {
        private final String name;

        NamedThreadExecutor(String name) {
            this.name = name;
        }

        @Override
        public void execute(Runnable command) {
            new Thread(command, this.name).start();
        }
    }

    public class CefVersion {
        public final int JCEF_COMMIT_NUMBER;
        public final String JCEF_COMMIT_HASH;
        public final int CEF_VERSION_MAJOR;
        public final int CEF_VERSION_MINOR;
        public final int CEF_VERSION_PATCH;
        public final int CEF_COMMIT_NUMBER;
        public final int CHROME_VERSION_MAJOR;
        public final int CHROME_VERSION_MINOR;
        public final int CHROME_VERSION_BUILD;
        public final int CHROME_VERSION_PATCH;

        protected CefVersion(int jcefCommitNo, String jcefCommitHash, int cefMajor, int cefMinor, int cefPatch, int cefCommitNo, int chrMajor, int chrMin, int chrBuild, int chrPatch) {
            this.JCEF_COMMIT_NUMBER = jcefCommitNo;
            this.JCEF_COMMIT_HASH = jcefCommitHash;
            this.CEF_VERSION_MAJOR = cefMajor;
            this.CEF_VERSION_MINOR = cefMinor;
            this.CEF_VERSION_PATCH = cefPatch;
            this.CEF_COMMIT_NUMBER = cefCommitNo;
            this.CHROME_VERSION_MAJOR = chrMajor;
            this.CHROME_VERSION_MINOR = chrMin;
            this.CHROME_VERSION_BUILD = chrBuild;
            this.CHROME_VERSION_PATCH = chrPatch;
        }

        public String getJcefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH + "." + this.JCEF_COMMIT_NUMBER + "." + this.JCEF_COMMIT_HASH;
        }

        public String getCefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH;
        }

        public String getChromeVersion() {
            return this.CHROME_VERSION_MAJOR + "." + this.CHROME_VERSION_MINOR + "." + this.CHROME_VERSION_BUILD + "." + this.CHROME_VERSION_PATCH;
        }

        public String toString() {
            return "JCEF Version = " + this.getJcefVersion() + "\nCEF Version = " + this.getCefVersion() + "\nChromium Version = " + this.getChromeVersion();
        }
    }
}

