/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.kafka.shell.command.CommandUtils;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.state.MetadataShellState;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public final class InteractiveShell
implements AutoCloseable {
    private final MetadataShellState state;
    private final Terminal terminal;
    private final History history;
    private final LineReader reader;

    public InteractiveShell(MetadataShellState state) throws IOException {
        this.state = state;
        TerminalBuilder builder = TerminalBuilder.builder().system(true).nativeSignals(true);
        this.terminal = builder.build();
        this.history = new DefaultHistory();
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).parser((Parser)new DefaultParser()).history(this.history).completer((Completer)new MetadataShellCompleter(state)).option(LineReader.Option.AUTO_FRESH_LINE, false).build();
    }

    /*
     * Loose catch block
     */
    public void runMainLoop() throws Exception {
        this.terminal.writer().println("[ Kafka Metadata Shell ]");
        this.terminal.flush();
        Commands commands = new Commands(true);
        while (true) {
            try {
                while (true) {
                    this.reader.readLine(">> ");
                    ParsedLine parsedLine = this.reader.getParsedLine();
                    Commands.Handler handler = commands.parseCommand(parsedLine.words());
                    handler.run(Optional.of(this), this.terminal.writer(), this.state);
                    this.terminal.writer().flush();
                }
            }
            catch (UserInterruptException eof) {
                this.terminal.writer().println("^C");
                continue;
            }
            break;
        }
        catch (EndOfFileException eof) {
            return;
        }
    }

    public int screenWidth() {
        return this.terminal.getWidth();
    }

    public Iterator<Map.Entry<Integer, String>> history(int numEntriesToShow) {
        int first;
        int last;
        if (numEntriesToShow < 0) {
            numEntriesToShow = 0;
        }
        if (numEntriesToShow > (last = this.history.last()) + 1) {
            numEntriesToShow = last + 1;
        }
        if ((first = last - numEntriesToShow + 1) < this.history.first()) {
            first = this.history.first();
        }
        return new HistoryIterator(first, last);
    }

    @Override
    public void close() throws IOException {
        this.terminal.close();
    }

    static class MetadataShellCompleter
    implements Completer {
        private final MetadataShellState state;

        MetadataShellCompleter(MetadataShellState state) {
            this.state = state;
        }

        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            if (line.words().isEmpty()) {
                CommandUtils.completeCommand("", candidates);
            } else if (line.words().size() == 1) {
                CommandUtils.completeCommand((String)line.words().get(0), candidates);
            } else {
                Iterator iter = line.words().iterator();
                String command = (String)iter.next();
                ArrayList<String> nextWords = new ArrayList<String>();
                while (iter.hasNext()) {
                    nextWords.add((String)iter.next());
                }
                Commands.Type type = (Commands.Type)Commands.TYPES.get(command);
                if (type == null) {
                    return;
                }
                try {
                    type.completeNext(this.state, nextWords, candidates);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public class HistoryIterator
    implements Iterator<Map.Entry<Integer, String>> {
        private final int last;
        private int index;

        HistoryIterator(int index, int last) {
            this.index = index;
            this.last = last;
        }

        @Override
        public boolean hasNext() {
            return this.index <= this.last;
        }

        @Override
        public Map.Entry<Integer, String> next() {
            if (this.index > this.last) {
                throw new NoSuchElementException();
            }
            int p = this.index++;
            return new AbstractMap.SimpleImmutableEntry<Integer, String>(p, InteractiveShell.this.history.get(p));
        }
    }
}

