/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;

public class Index
implements Exportable,
Serializable {
    private Identifier name;
    private Table table;
    private boolean unique;
    private String options = "";
    private final List<Selectable> selectables = new ArrayList<Selectable>();
    private final Map<Selectable, String> selectableOrderMap = new HashMap<Selectable, String>();

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public int getColumnSpan() {
        return this.selectables.size();
    }

    public List<Selectable> getSelectables() {
        return Collections.unmodifiableList(this.selectables);
    }

    public Map<Selectable, String> getSelectableOrderMap() {
        return Collections.unmodifiableMap(this.selectableOrderMap);
    }

    @Deprecated(since="6.3")
    public List<Column> getColumns() {
        return this.selectables.stream().map(selectable -> (Column)selectable).toList();
    }

    @Deprecated(since="6.3")
    public Map<Column, String> getColumnOrderMap() {
        return this.selectableOrderMap.entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> (Column)e.getKey(), Map.Entry::getValue));
    }

    public void addColumn(Selectable selectable) {
        if (!this.selectables.contains(selectable)) {
            this.selectables.add(selectable);
        }
    }

    public void addColumn(Selectable selectable, String order) {
        this.addColumn(selectable);
        if (StringHelper.isNotEmpty(order)) {
            this.selectableOrderMap.put(selectable, order);
        }
    }

    public String getName() {
        return this.name == null ? null : this.name.getText();
    }

    public void setName(String name) {
        this.name = Identifier.toIdentifier(name);
    }

    public String getQuotedName(Dialect dialect) {
        return this.name == null ? null : this.name.render(dialect);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")";
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(this.getTable().getExportIdentifier(), "IDX-" + this.getName());
    }
}

