/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.expiration;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.infinispan.client.hotrod.RemoteCache;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.expiration.BaseExpirationTask;
import org.keycloak.models.sessions.infinispan.expiration.ConsistentHash;

class RemoteExpirationTask
extends BaseExpirationTask {
    private final ConsistentHash consistentHash;

    RemoteExpirationTask(KeycloakSessionFactory factory, ScheduledExecutorService scheduledExecutorService, int intervalSeconds, Consumer<Duration> onTaskExecuted, RemoteCache<String, String> workCache, String nodeName) {
        super(factory, scheduledExecutorService, intervalSeconds, onTaskExecuted);
        this.consistentHash = ConsistentHash.create(workCache, scheduledExecutorService, UUID.randomUUID().toString(), nodeName, intervalSeconds);
    }

    @Override
    public final void start() {
        this.consistentHash.start();
        super.start();
    }

    @Override
    public final void stop() {
        super.stop();
        this.consistentHash.stop();
    }

    @Override
    final Predicate<RealmModel> realmFilter() {
        return this.consistentHash.consistentHashSnapshot();
    }

    int membersSize() {
        return this.consistentHash.size();
    }
}

