/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core;

import com.microsoft.windowsazure.core.FilterableService;
import com.microsoft.windowsazure.core.UserAgentFilter;
import com.microsoft.windowsazure.core.UserAgentFilterAdapter;
import com.microsoft.windowsazure.core.pipeline.apache.HttpRequestInterceptorBackAdapter;
import com.microsoft.windowsazure.core.pipeline.apache.HttpRequestInterceptorFrontAdapter;
import com.microsoft.windowsazure.core.pipeline.apache.HttpResponseInterceptorBackAdapter;
import com.microsoft.windowsazure.core.pipeline.apache.HttpResponseInterceptorFrontAdapter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class ServiceClient<TClient>
implements FilterableService<TClient>,
Closeable {
    private final ExecutorService executorService;
    private CloseableHttpClient httpClient;
    private HttpRequestInterceptorFrontAdapter httpRequestInterceptorFrontAdapter;
    private HttpRequestInterceptorBackAdapter httpRequestInterceptorBackAdapter;
    private HttpResponseInterceptorFrontAdapter httpResponseInterceptorFrontAdapter;
    private HttpResponseInterceptorBackAdapter httpResponseInterceptorBackAdapter;
    private final HttpClientBuilder httpClientBuilder;

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            String proxyHost = System.getProperty("http.proxyHost");
            String proxyPort = System.getProperty("http.proxyPort");
            if (proxyHost != null && proxyPort != null) {
                this.httpClientBuilder.setProxy(new HttpHost(proxyHost, Integer.parseInt(proxyPort)));
            }
            this.httpClient = this.httpClientBuilder.build();
        }
        return this.httpClient;
    }

    protected ServiceClient(HttpClientBuilder httpClientBuilder, ExecutorService executorService) {
        this.httpClientBuilder = httpClientBuilder;
        this.executorService = executorService;
        this.httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new UserAgentFilterAdapter(new UserAgentFilter()));
    }

    protected abstract TClient newInstance(HttpClientBuilder var1, ExecutorService var2);

    @Override
    public TClient withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        if (this.httpRequestInterceptorFrontAdapter == null) {
            this.httpRequestInterceptorFrontAdapter = new HttpRequestInterceptorFrontAdapter();
            this.httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)this.httpRequestInterceptorFrontAdapter);
        }
        this.httpRequestInterceptorFrontAdapter.addFront(serviceRequestFilter);
        return this.newInstance(this.httpClientBuilder, this.executorService);
    }

    @Override
    public TClient withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        if (this.httpRequestInterceptorBackAdapter == null) {
            this.httpRequestInterceptorBackAdapter = new HttpRequestInterceptorBackAdapter();
            this.httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)this.httpRequestInterceptorBackAdapter);
        }
        this.httpRequestInterceptorBackAdapter.addBack(serviceRequestFilter);
        return this.newInstance(this.httpClientBuilder, this.executorService);
    }

    @Override
    public TClient withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        if (this.httpResponseInterceptorFrontAdapter == null) {
            this.httpResponseInterceptorFrontAdapter = new HttpResponseInterceptorFrontAdapter();
            this.httpClientBuilder.addInterceptorFirst((HttpResponseInterceptor)this.httpResponseInterceptorFrontAdapter);
        }
        this.httpResponseInterceptorFrontAdapter.addFront(serviceResponseFilter);
        return this.newInstance(this.httpClientBuilder, this.executorService);
    }

    @Override
    public TClient withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        if (this.httpResponseInterceptorBackAdapter == null) {
            this.httpResponseInterceptorBackAdapter = new HttpResponseInterceptorBackAdapter();
            this.httpClientBuilder.addInterceptorLast((HttpResponseInterceptor)this.httpResponseInterceptorBackAdapter);
        }
        this.httpResponseInterceptorBackAdapter.addBack(serviceResponseFilter);
        return this.newInstance(this.httpClientBuilder, this.executorService);
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

