/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.eventstream.HeaderType;

public class Header {
    private String headerName;
    private HeaderType headerType;
    private byte[] headerValue;

    private Header() {
    }

    public static Header createHeader(String name, boolean value) {
        Header header = new Header();
        Header.checkHeaderNameLen(name);
        header.headerName = name;
        header.setValue(value);
        return header;
    }

    public static Header createHeader(String name, byte value) {
        Header header = new Header();
        Header.checkHeaderNameLen(name);
        header.headerName = name;
        header.setValue(value);
        return header;
    }

    public static Header createHeader(String name, String value) {
        Header header = new Header();
        Header.checkHeaderNameLen(name);
        header.headerName = name;
        header.setValue(value);
        return header;
    }

    public static Header createHeader(String name, short value) {
        Header header = new Header();
        Header.checkHeaderNameLen(name);
        header.headerName = name;
        header.setValue(value);
        return header;
    }

    public static Header createHeader(String name, int value) {
        Header header = new Header();
        Header.checkHeaderNameLen(name);
        header.headerName = name;
        header.setValue(value);
        return header;
    }

    public static Header createHeader(String name, long value) {
        Header header = new Header();
        Header.checkHeaderNameLen(name);
        header.headerName = name;
        header.setValue(value);
        return header;
    }

    public static Header createHeader(String name, Date value) {
        Header header = new Header();
        Header.checkHeaderNameLen(name);
        header.headerName = name;
        header.setValue(value);
        return header;
    }

    public static Header createHeader(String name, byte[] value) {
        Header header = new Header();
        Header.checkHeaderNameLen(name);
        header.headerName = name;
        header.setValue(value);
        return header;
    }

    public static Header createHeader(String name, UUID value) {
        Header header = new Header();
        Header.checkHeaderNameLen(name);
        header.headerName = name;
        header.setValue(value);
        return header;
    }

    public static Header fromByteBuffer(ByteBuffer buffer) {
        HeaderType headerType;
        Header header = new Header();
        byte nameLen = buffer.get();
        byte[] nameBuffer = new byte[nameLen];
        buffer.get(nameBuffer);
        header.headerName = new String(nameBuffer, StandardCharsets.UTF_8);
        byte type = buffer.get();
        header.headerType = headerType = HeaderType.getValueFromInt(type);
        switch (headerType) {
            case BooleanFalse: 
            case BooleanTrue: {
                break;
            }
            case Byte: {
                header.headerValue = new byte[1];
                buffer.get(header.headerValue);
                break;
            }
            case Int16: {
                header.headerValue = new byte[2];
                buffer.get(header.headerValue);
                break;
            }
            case Int32: {
                header.headerValue = new byte[4];
                buffer.get(header.headerValue);
                break;
            }
            case Int64: {
                header.headerValue = new byte[8];
                buffer.get(header.headerValue);
                break;
            }
            case ByteBuf: {
                short bufLen = buffer.getShort();
                byte[] bufValue = new byte[bufLen];
                buffer.get(bufValue);
                header.setValue(bufValue);
                break;
            }
            case String: {
                short strLen = buffer.getShort();
                byte[] strValue = new byte[strLen];
                buffer.get(strValue);
                header.setValue(new String(strValue, StandardCharsets.UTF_8));
                break;
            }
            case TimeStamp: {
                header.headerValue = new byte[8];
                buffer.get(header.headerValue);
                break;
            }
            case UUID: {
                header.headerValue = new byte[16];
                buffer.get(header.headerValue);
                break;
            }
            default: {
                throw new CrtRuntimeException("Invalid event-stream header buffer.");
            }
        }
        return header;
    }

    public void writeToByteBuffer(ByteBuffer buffer) {
        buffer.put((byte)this.headerName.length());
        buffer.put(this.headerName.getBytes(StandardCharsets.UTF_8));
        buffer.put((byte)this.headerType.getEnumIntValue());
        if (this.headerType != HeaderType.BooleanFalse && this.headerType != HeaderType.BooleanTrue) {
            buffer.put(this.headerValue);
        }
    }

    public String getName() {
        return this.headerName;
    }

    public HeaderType getHeaderType() {
        return this.headerType;
    }

    public boolean getValueAsBoolean() {
        if (this.headerType != HeaderType.BooleanTrue && this.headerType != HeaderType.BooleanFalse) {
            throw new CrtRuntimeException("Invalid Event-stream header type");
        }
        return this.headerType == HeaderType.BooleanTrue;
    }

    private void setValue(boolean value) {
        this.headerType = value ? HeaderType.BooleanTrue : HeaderType.BooleanFalse;
    }

    public byte getValueAsByte() {
        this.checkType(HeaderType.Byte);
        return this.headerValue[0];
    }

    private void setValue(byte value) {
        this.headerType = HeaderType.Byte;
        this.headerValue = new byte[]{value};
    }

    public short getValueAsShort() {
        this.checkType(HeaderType.Int16);
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.headerValue);
        return valueBuffer.getShort();
    }

    private void setValue(short value) {
        this.headerType = HeaderType.Int16;
        ByteBuffer valueBuffer = ByteBuffer.allocate(2);
        valueBuffer.putShort(value);
        this.headerValue = valueBuffer.array();
    }

    public int getValueAsInt() {
        this.checkType(HeaderType.Int32);
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.headerValue);
        return valueBuffer.getInt();
    }

    private void setValue(int value) {
        this.headerType = HeaderType.Int32;
        ByteBuffer valueBuffer = ByteBuffer.allocate(4);
        valueBuffer.putInt(value);
        this.headerValue = valueBuffer.array();
    }

    public long getValueAsLong() {
        this.checkType(HeaderType.Int64);
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.headerValue);
        return valueBuffer.getLong();
    }

    private void setValue(long value) {
        this.headerType = HeaderType.Int64;
        ByteBuffer valueBuffer = ByteBuffer.allocate(8);
        valueBuffer.putLong(value);
        this.headerValue = valueBuffer.array();
    }

    public Date getValueAsTimestamp() {
        this.checkType(HeaderType.TimeStamp);
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.headerValue);
        return new Date(valueBuffer.getLong());
    }

    private void setValue(Date value) {
        this.headerType = HeaderType.TimeStamp;
        ByteBuffer valueBuffer = ByteBuffer.allocate(8);
        valueBuffer.putLong(value.getTime());
        this.headerValue = valueBuffer.array();
    }

    public byte[] getValueAsBytes() {
        this.checkType(HeaderType.ByteBuf);
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.headerValue);
        short len = valueBuffer.getShort();
        byte[] bufferVal = new byte[len];
        valueBuffer.get(bufferVal);
        return bufferVal;
    }

    private void setValue(byte[] value) {
        if (value.length > Short.MAX_VALUE) {
            throw new CrtRuntimeException("The max length for a ByteBuf Header value is Short.MAX_VALUE");
        }
        this.headerType = HeaderType.ByteBuf;
        ByteBuffer valueBuffer = ByteBuffer.allocate(this.headerType.getWireBytesOverhead() + value.length);
        valueBuffer.putShort((short)value.length);
        valueBuffer.put(value);
        this.headerValue = valueBuffer.array();
    }

    public String getValueAsString() {
        this.checkType(HeaderType.String);
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.headerValue);
        short len = valueBuffer.getShort();
        byte[] bufferVal = new byte[len];
        valueBuffer.get(bufferVal);
        return new String(bufferVal, StandardCharsets.UTF_8);
    }

    private void setValue(String value) {
        if (value.length() > Short.MAX_VALUE) {
            throw new CrtRuntimeException("The max length for a String Header value is Short.MAX_VALUE");
        }
        this.headerType = HeaderType.String;
        ByteBuffer valueBuffer = ByteBuffer.allocate(this.headerType.getWireBytesOverhead() + value.length());
        valueBuffer.putShort((short)value.length());
        valueBuffer.put(value.getBytes(StandardCharsets.UTF_8));
        this.headerValue = valueBuffer.array();
    }

    public UUID getValueAsUUID() {
        int i;
        this.checkType(HeaderType.UUID);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(this.headerValue[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(this.headerValue[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    private void setValue(UUID value) {
        this.headerType = HeaderType.UUID;
        ByteBuffer valueBuffer = ByteBuffer.allocate(16);
        valueBuffer.putLong(value.getMostSignificantBits());
        valueBuffer.putLong(value.getLeastSignificantBits());
        this.headerValue = valueBuffer.array();
    }

    public int getTotalByteLength() {
        int length = 1 + this.headerName.length() + 1;
        return length += this.headerValue != null ? this.headerValue.length : 0;
    }

    public static byte[] marshallHeadersForJNI(List<Header> headers) {
        int totalWireLength = 0;
        for (Header header : headers) {
            totalWireLength += header.getTotalByteLength();
        }
        byte[] marshalledData = new byte[totalWireLength];
        ByteBuffer marshalledBuf = ByteBuffer.wrap(marshalledData);
        for (Header header : headers) {
            header.writeToByteBuffer(marshalledBuf);
        }
        return marshalledData;
    }

    private void checkType(HeaderType headerType) {
        if (this.headerType != headerType) {
            throw new CrtRuntimeException("Invalid Event-stream header type");
        }
    }

    private static void checkHeaderNameLen(String headerName) {
        if (headerName.length() >= 127) {
            throw new CrtRuntimeException("Header name must be less than 127 bytes.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return this.headerName.equals(header.headerName) && this.headerType == header.headerType && Arrays.equals(this.headerValue, header.headerValue);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.headerName, this.headerType});
        result = 31 * result + Arrays.hashCode(this.headerValue);
        return result;
    }
}

